=============================================================================================================================================================

## Version Release v4.0.0 MC-1.20.1 - Refactor Update

## Notes
- **IMPORTANT** - Many effects from previous versions have been moved into attributes, all removed effects can be remade using these attributes
- This update will arrive for 1.21 aswell in the future once I have time and some bugs have been ironed out
- License has now been opened up from All Rights Reserved to MIT License (Modified), read LICENSE.txt for more information

## MultiLoader Utilities
- Added new MultiLoader utilities built-in registry helper, this can intake a custom mod id
- Allows creating flammable registries within the common code by utilizing the createFlammable method in TLRegistryHelper
- Added a couple of publicized classes such as PublicMobEffect or PublicStairBlock, these are just because they are typically protected

## Effects
- Added Tempus: works like Chronos but in reverse (ticks effects quicker)
- Added Creative Shock: damages the user when building
- Chronos now ticks effects down slower rather than freezing them (does not tick itself)
- Chronos (and also now Tempus) blacklists any instances of InstantaneousEffect
- Internal Bleeding is now Blood Clot
- Perception no longer glows the user of the effect itself
- Traversal can now teleport players to spawn if no spawn is found (before it would just send them to their last spawn)

## Attributes
- dodge_chance: chance from 0 to 100 to negate any damage not tagged in the `bypasses_dodge` tag (pre v4.0 effect was Diversion)
- lifesteal_chance: chance from 0 to 100 to heal an amount of health determined from `lifesteal_heal_amount` (pre v4.0 effect was Devour)
- lifesteal_heal_amount: amount of health from 0 to 1024 to heal when `lifesteal_chance` activates (pre v4.0 effect was Devour)
- vulnerability_chance: chance from 0 to 100 to cause additional damage determined from `vulnerability_multiplier` (pre v4.0 effect was Shatterspleen)
- vulnerability_multiplier: the modified amount of damage the user is caused when `vulnerability_chance` activates (pre v4.0 effect was Shatterspleen)
- retaliation_chance: chance from 0 to 100 to cause damage controlled by `retaliation_amount` back to the entity that attacked the user (pre v4.0 effect was Retaliation)
- retaliation_amount: amount of damage done back to the attacker of the user when `retaliation_chance` activates (pre v4.0 effect was Retaliation)
- burning_retaliation_chance: chance from 0 to 100 to burn attackers of the user for a time controlled by `burning_retaliation_length` (pre v4.0 effect was Burning Thorns)
- burning_retaliation_length: amount of time in ticks to burn the attacker of the user when `burning_retaliation_chance` activates (pre v4.0 effect was Burning Thorns)
- critical_strike_chance: chance from 0 to 100 to deal additional damage controlled by `critical_strike_multiplier` to an attacked entity
- critical_strike_multiplier: amount of additional damage done to an entity when `critical_strike_chance` activates
- rejuvenate_chance: chance from 0 to 100 to heal an amount of health controlled by `rejuvenate_amount` when damaged
- rejuvenate_amount: amount of health healed when `rejuvenate_heal_amount` is activated

## Technical Changes
- The TipsyLibConstants.java has been deleted, you can now get the MOD_ID from TipsyLib.java
- TLStatusEffects has been refactored to TLMobEffects

## Misc Changes
- Updated the logo of the mod
- Updated the textures of many effect icons
- Updated death messages
- Updated contributor capes

=============================================================================================================================================================