/* 
 * ServerEvents.recipes(callback) is a function that accepts another function,
 * called the "callback", as a parameter. The callback gets run when the 
 * server is working on recipes, and then we can make our own changes.
 * When the callback runs, it is also known as the event "firing". 
*/

// Listen for the "recipes" server event.
ServerEvents.recipes(event => {
    // Functional Storage: Nether Upgrade
    event.shapeless(
        Item.of('functionalstorage:netherite_upgrade', 1), // arg 1: output
        [
            'minecraft:netherite_ingot',
            'functionalstorage:diamond_upgrade'
        ]
    )
    
    // Unobtainium Allthemodium Alloy Dust
    event.shapeless(
        Item.of('allthemodium:unobtainium_allthemodium_alloy_dust', 2),
        [
            'allthemodium:unobtainium_dust',
            'allthemodium:allthemodium_dust',
            'allthemodium:piglich_heart_block'
        ]
    )
    
    // Vibranium Allthemodium Alloy Dust
    event.shapeless(
        Item.of('allthemodium:vibranium_allthemodium_alloy_dust', 2),
        [
            'allthemodium:vibranium_dust',
            'allthemodium:allthemodium_dust',
            'allthemodium:piglich_heart_block'
        ]
    )
    
    // Unobtainium Vibranium Alloy Dust
    event.shapeless(
        Item.of('allthemodium:unobtainium_vibranium_alloy_dust', 2),
        [
            'allthemodium:unobtainium_dust',
            'allthemodium:vibranium_dust',
            'allthemodium:piglich_heart_block'
        ]
    )
    
    // Dragon Egg => Dragon Skull
    event.shapeless(
        Item.of('minecraft:dragon_head', 1),
        [
            'minecraft:dragon_egg'
        ]
    )
    
    // Dragon Skull => Dragon Egg
    event.shapeless(
        Item.of('minecraft:dragon_egg', 1),
        [
            'minecraft:dragon_head'
        ]
    )
    
    // Alternate Flux Dust
    event.shapeless(
        Item.of('fluxnetworks:flux_dust', 2),
        [
            'minecraft:redstone',
            '#forge:dusts/obsidian'
        ]
    )
    
    // Allthemodium Alloy Sword
    event.shaped(Item.of('allthemodium:alloy_sword'), [
        ' A ',
        ' B ',
        ' C '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        C: 'allthemodium:allthemodium_rod'
    })
    
    // Allthemodium Alloy Axe
    event.shaped(Item.of('allthemodium:alloy_axe'), [
        'BA ',
        'DC ',
        ' C '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        C: 'allthemodium:allthemodium_rod',
        D: 'allthemodium:unobtainium_allthemodium_alloy_ingot'
    })
    
    // Allthemodium Alloy Pickaxe
    event.shaped(Item.of('allthemodium:alloy_pick'), [
        'BAD',
        ' C ',
        ' C '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        C: 'allthemodium:allthemodium_rod',
        D: 'allthemodium:unobtainium_allthemodium_alloy_ingot'
    })
    
    // Allthemodium Alloy Shovel
    event.shaped(Item.of('allthemodium:alloy_shovel'), [
        ' A ',
        ' C ',
        ' C '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'allthemodium:allthemodium_rod',
    })
    
    // Allthemodium Alloy Paxel
    event.shaped(Item.of('allthemodium:alloy_paxel'), [
        'ABC',
        ' D ',
        ' D '
    ], {
        A: 'allthemodium:alloy_axe',
        B: 'allthemodium:alloy_pick',
        C: 'allthemodium:alloy_shovel',
        D: 'allthemodium:allthemodium_rod',
    })
    
    // Treated Wood Planks
    event.shaped(Item.of('immersiveengineering:treated_wood_horizontal', 8), [
        'AAA',
        'ABA',
        'AAA'
    ], {
            A: 'minecraft:oak_planks',
            B: 'minecraft:brown_dye',
    })
    
    // Logs to Chest
    event.shaped(Item.of('minecraft:chest', 4), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: '#minecraft:logs',
    })
    
    // Godforged Pearl
    event.shaped(Item.of('apotheosis:mythic_material', 1), [
        'AAA',
        'ABA',
        'AAA'
    ], {
            A: 'apotheosis:gem_dust',
            B: 'allthemodium:allthemodium_ingot'
    })
    
    // Thermal Rubber
    event.shaped(Item.of('thermal:rubber', 1), [
        'AAA',
        '   ',
        '   '
    ], {
            A: 'mysticalagriculture:rubber_essence'
    })
    
    // Industrial Foregoing Dry Rubber
    event.shaped(Item.of('industrialforegoing:dryrubber', 3), [
        'AAA',
        'AAA',
        'AAA'
    ], {
            A: 'mysticalagriculture:rubber_essence'
    })
    
    // Brass Dust
    event.shaped(Item.of('alltheores:brass_dust', 4), [
        'AA ',
        'AB ',
        '   '
    ], {
            A: 'mekanism:dust_copper',
            B: 'alltheores:zinc_dust'
    })
    
    // Bronze Dust
    event.shaped(Item.of('alltheores:bronze_dust', 4), [
        'AA ',
        'AB ',
        '   '
    ], {
            A: 'mekanism:dust_copper',
            B: 'alltheores:tin_dust'
    })
    
    // Lumium Dust
    event.shaped(Item.of('alltheores:lumium_dust', 4), [
        'AAA',
        'ABC',
        'CC '
    ], {
            A: 'minecraft:glowstone_dust',
            B: 'alltheores:silver_dust',
            C: 'mekanism:dust_tin'
    })
    
    // Lumium Dust
    event.shaped(Item.of('alltheores:lumium_dust', 4), [
        'AAA',
        'ABC',
        'CC '
    ], {
            A: 'minecraft:glowstone_dust',
            B: 'moremekanismprocessing:dust_silver',
            C: 'mekanism:dust_tin'
    })
    
    // Enderium Dust
    event.shaped(Item.of('alltheores:enderium_dust', 4), [
        'AAA',
        'ABC',
        'CCC'
    ], {
            A: 'alltheores:lead_dust',
            B: 'alltheores:platinum_dust',
            C: 'ae2:ender_dust'
    })
    
    // Enderium Dust
    event.shaped(Item.of('alltheores:enderium_dust', 4), [
        'AAA',
        'ABC',
        'CCC'
    ], {
            A: 'mekanism:dust_lead',
            B: 'alltheores:platinum_dust',
            C: 'ae2:ender_dust'
    })
    
    // Fertile Essence
    event.shaped(Item.of('reliquary:fertile_essence', 1), [
        'AAA',
        'AAA',
        'AAA'
    ], {
            A: 'mysticalagriculture:fertilized_essence'
    })
    
    // Allthemodium Essence > Allthemodium Ingot
    event.shaped(Item.of('allthemodium:allthemodium_ingot', 1), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: 'mysticalagriculture:allthemodium_essence'
    })
    
    // Vibranium Essence > Vibranium Ingot
    event.shaped(Item.of('allthemodium:vibranium_ingot', 1), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: 'mysticalagriculture:vibranium_essence'
    })
    
    // Unobtainium Essence > Unobtainium Ingot
    event.shaped(Item.of('allthemodium:unobtainium_ingot', 1), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: 'mysticalagriculture:unobtainium_essence'
    })
    
    // Crimson Iron Essence > Crimson Iron Ingot
    event.shaped(Item.of('silentgear:crimson_iron_ingot', 4), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: 'mysticalagriculture:crimson_iron_essence'
    })

    // Azure Silver Ingot
    event.shaped(Item.of('silentgear:azure_silver_ingot', 4), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: 'mysticalagriculture:azure_silver_essence'
    })
    
    // Crude Horizontal Dark Oak Planks
    event.shaped(Item.of('chisel:crude_horizontal/dark_oak_planks', 3), [
        'A  ',
        ' A ',
        '  A'
    ], {
            A: 'minecraft:dark_oak_planks'
    })
    
    // Deepslate Pillar
    event.shaped(Item.of('create:deepslate_pillar', 3), [
        ' A ',
        ' A ',
        ' A '
    ], {
            A: 'minecraft:deepslate'
    })
    
    // Stone Panel
    event.shaped(Item.of('chisel:panel/stone', 4), [
        'A A',
        '   ',
        'A A'
    ], {
            A: 'minecraft:stone'
    })
    
    // Apatite Essence
    event.shaped(Item.of('thermal:apatite', 3), [
        'AAA',
        'AAA',
        'AAA'
    ], {
            A: 'mysticalagriculture:apatite_essence'
    })
    
    // Basalt Essence
    event.shaped(Item.of('minecraft:basalt', 4), [
        'AAA',
        'A A',
        'AAA'
    ], {
            A: 'mysticalagriculture:basalt_essence'
    })

    event.smelting(Item.of('allthemodium:unobtainium_allthemodium_alloy_ingot'), Ingredient.of('allthemodium:unobtainium_allthemodium_alloy_dust'), 0.7, '10s')
    event.blasting(Item.of('allthemodium:unobtainium_allthemodium_alloy_ingot'), Ingredient.of('allthemodium:unobtainium_allthemodium_alloy_dust'), 0.7, '5s')
    
    event.smelting(Item.of('allthemodium:unobtainium_vibranium_alloy_ingot'), Ingredient.of('allthemodium:unobtainium_vibranium_alloy_dust'), 0.7, '10s')
    event.blasting(Item.of('allthemodium:unobtainium_vibranium_alloy_ingot'), Ingredient.of('allthemodium:unobtainium_vibranium_alloy_dust'), 0.7, '5s')
    
    event.smelting(Item.of('allthemodium:vibranium_allthemodium_alloy_ingot'), Ingredient.of('allthemodium:vibranium_allthemodium_alloy_dust'), 0.7, '10s')
    event.blasting(Item.of('allthemodium:vibranium_allthemodium_alloy_ingot'), Ingredient.of('allthemodium:vibranium_allthemodium_alloy_dust'), 0.7, '5s')
    
    
    function mekcrush(output, input, outcount) {
        event.custom({
            type: 'mekanism:crushing',
            input: {
                ingredient: {
                    item: input // Input item
                }
            },
            output: {
                item: output, // Output item
                count: outcount
            }
        });
    }
    
    mekcrush('alltheores:iron_dust', 'minecraft:iron_ingot', 1)
    mekcrush('alltheores:iron_dust', 'minecraft:raw_iron', 2)
    mekcrush('alltheores:gold_dust', 'minecraft:gold_ingot', 1)
    mekcrush('alltheores:gold_dust', 'minecraft:raw_gold', 2)
    mekcrush('alltheores:copper_dust', 'minecraft:copper_ingot', 1)
    mekcrush('alltheores:copper_dust', 'minecraft:raw_copper', 2)
    mekcrush('alltheores:osmium_dust', 'alltheores:osmium_ingot', 1)
    mekcrush('alltheores:osmium_dust', 'alltheores:raw_osmium', 2)
    mekcrush('mekanism:dust_obsidian', 'minecraft:obsidian', 4)
    mekcrush('thermal:sulfur_dust', 'thermal:sulfur', 1)
    mekcrush('alltheores:tin_dust', 'alltheores:tin_ingot', 1)
    mekcrush('alltheores:tin_dust', 'alltheores:raw_tin', 2)
    mekcrush('alltheores:tin_dust', 'mekanism:ingot_tin', 1)
    mekcrush('alltheores:tin_dust', 'mekanism:raw_tin', 2)
    mekcrush('alltheores:tin_dust', 'thermal:raw_tin', 2)
    mekcrush('ae2:ender_dust', 'minecraft:ender_pearl', 9)
    mekcrush('alltheores:lead_dust', 'alltheores:lead_ingot', 1)
    mekcrush('alltheores:lead_dust', 'immersiveengineering:ingot_lead', 1)
    mekcrush('alltheores:lead_dust', 'mekanism:ingot_lead', 1)
    mekcrush('alltheores:lead_dust', 'thermal:lead_ingot', 1)
    mekcrush('alltheores:lead_dust', 'alltheores:raw_lead', 2)
    mekcrush('alltheores:lead_dust', 'immersiveengineering:raw_lead', 2)
    mekcrush('alltheores:lead_dust', 'mekanism:raw_lead', 2)
    mekcrush('alltheores:lead_dust', 'thermal:raw_lead', 2)
    
    function botanysoil(soilItem,displayBlock,category,growthTicks,growthModifier) {
        event.recipes.botanypots.soil(
            soilItem, // the item that this soil is attached to
            { block: displayBlock }, // display block
            [category], // categories that this soil provides
            growthTicks, // growth ticks that this soil will provide, set to -1 for no modifier
            growthModifier // optional, growth modifier, example: 0.5 means all crops will take half the time
        )
    }
    
    botanysoil('kubejs:magical_soil','kubejs:magical_soil','magical',-1,1.75)

    function botanycrop(seedItem,category,displayBlock,outputItem,chance,min,max,growthTicks,growthModifier) {
        event.recipes.botanypots.crop(
            seedItem, // seed item
            [category], // categories that this crop can be planted on
            { block: displayBlock }, // display block
            [
                Item.of(outputItem) // item
                    .withChance(chance) // weight of this entry compared to the others
                    .withRolls(min, max) // the times this loot will be chosen (min, max)
            ],
            10, // growthTicks
            1 // optional, growthModifier - this can be set to 1 in most cases
        )
    }
    
    botanycrop('mysticalagriculture:allthemodium_seeds','magical','mysticalagriculture:allthemodium_crop','mysticalagriculture:allthemodium_essence',100,2,4,10,1)
    botanycrop('mysticalagriculture:vibranium_seeds','magical','mysticalagriculture:vibranium_crop','mysticalagriculture:vibranium_essence',100,2,4,10,1)
    botanycrop('mysticalagriculture:unobtainium_seeds','magical','mysticalagriculture:unobtainium_crop','mysticalagriculture:unobtainium_essence',100,2,4,10,1)
    botanycrop('mysticalagriculture:azure_silver_seeds','tertium','mysticalagriculture:azure_silver_crop','mysticalagriculture:azure_silver_essence',100,2,4,10,1)
    botanycrop('mysticalagriculture:crimson_iron_seeds','tertium','mysticalagriculture:crimson_iron_crop','mysticalagriculture:crimson_iron_essence',100,2,4,10,1)
    
    // Creative Item Recipes - Target is ~2.7m total items for each creative item
    // Mekanism:Creative Energy Cube
    event.shaped(Item.of('mekanism:creative_energy_cube',1), [
        'ABA',
        'CDC',
        'ABA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        C: 'allthemodium:unobtainium_allthemodium_alloy_ingot',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Mekanism:Creative Bin
    event.shaped(Item.of('mekanism:creative_bin',1), [
        'ABA',
        'CDC',
        'AAA'
    ], {
        A: 'minecraft:cobblestone',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'allthemodium:unobtainium_allthemodium_alloy_ingot',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Mekanism:Creative Fluid Tank
    event.shaped(Item.of('mekanism:creative_fluid_tank',1), [
        'ADA',
        'B B',
        'AAA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Mekanism:Creative Chemical Tank
    event.shaped(Item.of('mekanism:creative_chemical_tank',1), [
        'ADA',
        'C C',
        'AAA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'allthemodium:unobtainium_allthemodium_alloy_ingot',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Mekanism:Creative Solar Panel
    event.shaped(Item.of('solarpanels:creative_solar_panel',1), [
        'AAA',
        'CDC',
        'BBB'
    ], {
        A: 'solarpanels:carbone_solar_element',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'allthemodium:unobtainium_allthemodium_alloy_ingot',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Botania:The Everlasting Guilty Pool
    event.shaped(Item.of('botania:creative_pool',1), [
        '   ',
        'BCB',
        'AAA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'botania:livingrock',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Botania:Storm Lens
    event.shaped(Item.of('botania:lens_storm',1), [
        ' A ',
        'ABA',
        ' A '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity'
    })
    
    // Thermal:Almost Creative Integral Component
    event.shaped(Item.of('thermal_more:super_upgrade_augment',1), [
        'CCC',
        'ABA',
        'AAA'
    ], {
        A: 'thermal:netherite_gear',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'allthemodium:unobtainium_vibranium_alloy_ingot'
    })
    
    // Thermal:Creative RF Coil
    event.shaped(Item.of('thermal:rf_coil_creative_augment',1), [
        ' A ',
        'ABA',
        ' C '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'allthemodium:allthemodium_ingot'
    })
    
    // Thermal:Creative Tank Construction
    event.shaped(Item.of('thermal:fluid_tank_creative_augment',1), [
        'ABA',
        'BCB',
        'ABA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'thermal:cured_rubber',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Thermal:Creative Flux Efficiency
    event.shaped(Item.of('thermal:machine_efficiency_creative_augment',1), [
        ' A ',
        'BCB',
        ' A '
    ], {
        A: 'thermal:netherite_gear',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Thermal:Creative Reclamation Chamber
    event.shaped(Item.of('thermal:machine_catalyst_creative_augment',1), [
        ' A ',
        'BCB',
        ' A '
    ], {
        A: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Pipez:Infinity Pipe Upgrade
    event.shaped(Item.of('pipez:infinity_upgrade',1), [
        'ABA',
        'ACA',
        'ADA'
    ], {
        A: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'pipez:ultimate_upgrade',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Immersive Engineering:Creative Accumulator
    event.shaped(Item.of('immersiveengineering:capacitor_creative',1), [
        'ABA',
        'CDC',
        'AEA'
    ], {
        A: '#forge:treated_wood',
        B: '#forge:plates/aluminum',
        C: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        D: 'extendedcrafting:ultimate_singularity',
        E: 'immersiveengineering:ingot_hop_graphite'
    })
    
    // Integrated Dynamics: Creative Energy Batter
    event.shaped(Item.of('integrateddynamics:energy_battery_creative',1), [
        'ABA',
        'ACA',
        'ABA'
    ], {
        A: 'integrateddynamics:crystalized_menril_chunk',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Industrial Foregoing: Creative Capacitor
    event.shaped(Item.of('ifeu:creative_capacitor',1), [
        'BCB',
        'EDE',
        'AAA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'industrialforegoing:plastic',
        C: 'extendedcrafting:ultimate_singularity',
        D: 'industrialforegoing:machine_frame_supreme',
        E: 'minecraft:nether_star'
    })
    
    // Mystical Agriculture: Creative Essence
    event.shaped(Item.of('mysticalagradditions:creative_essence',1), [
        'AAA',
        'ABA',
        'AAA'
    ], {
        A: 'mysticalagriculture:awakened_supremium_essence',
        B: 'extendedcrafting:ultimate_singularity'
    })
    
    // Mystical Agriculture: Soulium Dagger
    event.shaped(Item.of('mysticalagriculture:creative_soulium_dagger',1), [
        ' A ',
        ' B ',
        ' C '
    ], {
        A: 'mysticalagradditions:creative_essence',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'allthemodium:allthemodium_rod'
    })
    
    // Refined Storage: Creative Controller
    event.shaped(Item.of('refinedstorage:creative_controller',1), [
        'ABA',
        'CDC',
        'ACA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity',
        C: '#forge:silicon',
        D: 'refinedstorage:machine_casing'
    })
    
    // Refined Storage: Creative Storage Disk
    event.shaped(Item.of('refinedstorage:creative_storage_disk',1), [
        'AAA',
        'ACA',
        'ABA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'refinedstorage:storage_housing',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Refined Storage: Creative Fluid Disk
    event.shaped(Item.of('refinedstorage:creative_fluid_storage_disk',1), [
        'AAA',
        'ACA',
        'ABA'
    ], {
        A: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        B: 'refinedstorage:storage_housing',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Refined Storage: Creative Storage Block
    event.shaped(Item.of('refinedstorage:creative_storage_block',1), [
        'ABA',
        'ACA',
        'ADA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'refinedstorage:machine_casing',
        D: 'minecraft:redstone'
    })
    
    // Refined Storage: Creative Fluid Block
    event.shaped(Item.of('refinedstorage:creative_fluid_storage_block',1), [
        'ABA',
        'ACA',
        'ADA'
    ], {
        A: 'allthemodium:vibranium_allthemodium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'refinedstorage:machine_casing',
        D: 'minecraft:redstone'
    })
    
    // Refined Storage: Creative Wireless Crafting Grid
    event.shaped(Item.of('refinedstorageaddons:creative_wireless_crafting_grid',1), [
        'ABA',
        'ACA',
        'ADA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'minecraft:ender_pearl',
        C: '#refinedstorage:crafting_grid',
        D: 'extendedcrafting:ultimate_singularity'
    })
    
    // Powah: Energy Cell (Creative)
    event.shaped(Item.of('powah:energy_cell_creative',1), [
        'ABA',
        'DCD',
        'ABA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'powah:capacitor_nitro',
        C: 'extendedcrafting:ultimate_singularity',
        D: 'powah:energy_cell_nitro'
    })
    
    // Create: Creative Motor
    event.shaped(Item.of('create:creative_motor',1), [
        'AAA',
        'ACA',
        'ABA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'createaddition:electric_motor'
    })
    
    // Create: Creative Fluid Tank
    event.shaped(Item.of('create:creative_fluid_tank',1), [
        'AAA',
        'ACA',
        'ABA'
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'create:fluid_tank'
    })
    
    // Create: Creative Blaze Cake
    event.shaped(Item.of('create:creative_blaze_cake',1), [
        ' A ',
        ' B ',
        '   '
    ], {
        A: 'extendedcrafting:ultimate_singularity',
        B: 'create:blaze_cake_base'
    })
    
    // Create: Creative Worldshaper
    event.shaped(Item.of('create:handheld_worldshaper',1), [
        'A  ',
        ' B ',
        ' CB'
    ], {
        A: 'extendedcrafting:ultimate_singularity',
        B: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        C: 'allthemodium:unobtainium_allthemodium_alloy_ingot'
    })
    
    // Create: Creative Generator
    event.shaped(Item.of('createaddition:creative_energy',1), [
        'AAA',
        'CBC',
        'CCC'
    ], {
        A: 'create:brass_casing',
        B: 'extendedcrafting:ultimate_singularity',
        C: 'allthemodium:unobtainium_vibranium_alloy_ingot'
    })
    
    // Applied Energistics 2: Creative ME Item Cell
    event.shaped(Item.of('ae2:creative_item_cell',1), [
        ' A ',
        'ACA',
        ' B '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'ae2:item_cell_housing',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Applied Energistics 2: Creative ME Fluid Cell
    event.shaped(Item.of('ae2:creative_fluid_cell',1), [
        ' A ',
        'ACA',
        ' B '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'ae2:fluid_cell_housing',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Applied Energistics 2: Creative ME Chemical Cell
    event.shaped(Item.of('appmek:creative_chemical_cell',1), [
        ' A ',
        'ACA',
        ' B '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'appmek:chemical_cell_housing',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Applied Energistics 2: Creative ME Mana Cell
    event.shaped(Item.of('appbot:creative_mana_cell',1), [
        ' A ',
        'ACA',
        ' B '
    ], {
        A: 'allthemodium:unobtainium_vibranium_alloy_ingot',
        B: 'appbot:mana_cell_housing',
        C: 'extendedcrafting:ultimate_singularity'
    })
    
    // Applied Energistics 2: Creative Energy Cell
    event.shaped(Item.of('ae2:creative_energy_cell',1), [
        ' A ',
        'ABA',
        ' A '
    ], {
        A: 'ae2:dense_energy_cell',
        B: 'extendedcrafting:ultimate_singularity'
    })
});

// Listen to item tag event
ServerEvents.tags('item', event => {
    function addITag(customTag,item) {
        event.add(customTag,item)
    }
    
    addITag('animal_pen:can_attack_pen','allthemodium:allthemodium_sword')
    addITag('animal_pen:can_attack_pen','allthemodium:allthemodium_axe')
    addITag('animal_pen:can_attack_pen','allthemodium:vibranium_sword')
    addITag('animal_pen:can_attack_pen','allthemodium:vibranium_axe')
    addITag('animal_pen:can_attack_pen','allthemodium:unobtainium_sword')
    addITag('animal_pen:can_attack_pen','allthemodium:unobtainium_axe')
    addITag('animal_pen:can_attack_pen','allthemodium:alloy_sword')
    addITag('animal_pen:can_attack_pen','allthemodium:alloy_axe')
    
    addITag('animal_pen:can_attack_aquarium','allthemodium:allthemodium_sword')
    addITag('animal_pen:can_attack_aquarium','allthemodium:allthemodium_axe')
    addITag('animal_pen:can_attack_aquarium','allthemodium:vibranium_sword')
    addITag('animal_pen:can_attack_aquarium','allthemodium:vibranium_axe')
    addITag('animal_pen:can_attack_aquarium','allthemodium:unobtainium_sword')
    addITag('animal_pen:can_attack_aquarium','allthemodium:unobtainium_axe')
    addITag('animal_pen:can_attack_aquarium','allthemodium:alloy_sword')
    addITag('animal_pen:can_attack_aquarium','allthemodium:alloy_axe')

});