/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.inventory.IndexedInventory;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

@OnlyIn(value=Dist.CLIENT, _interface=LidBlockEntity.class)
public class BlockEntityColossalChest
extends CyclopsBlockEntity
implements MenuProvider,
LidBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityColossalChest.playSound(level, pos, blockState, SoundEvents.f_11749_, BlockEntityColossalChest.this.getSizeSingular());
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityColossalChest.playSound(level, pos, blockState, SoundEvents.f_11747_, BlockEntityColossalChest.this.getSizeSingular());
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityColossalChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ContainerColossalChest)) {
                return false;
            }
            Container container = ((ContainerColossalChest)player.f_36096_).getContainerInventory();
            return container == BlockEntityColossalChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private SimpleInventory lastValidInventory = null;
    private SimpleInventory inventory = null;
    private LazyOptional<IItemHandler> capabilityItemHandler = LazyOptional.empty();
    @NBTPersist
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.f_123288_);
    @NBTPersist
    private Vec3 renderOffset = new Vec3(0.0, 0.0, 0.0);
    private Component customName = null;
    @NBTPersist
    private int materialId = 0;
    @NBTPersist
    private int rotation = 0;
    @NBTPersist(useDefaultValue=false)
    private List<Vec3i> interfaceLocations = Lists.newArrayList();
    private boolean recreateNullInventory = true;
    private EnumFacingMap<int[]> facingSlots = EnumFacingMap.newMap();

    public BlockEntityColossalChest(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST, blockPos, blockState);
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.facingSlots.clear();
        if (this.isStructureComplete()) {
            this.setInventory((SimpleInventory)this.constructInventory());
            if (this.lastValidInventory != null) {
                int slot;
                for (slot = 0; slot < Math.min(this.lastValidInventory.m_6643_(), this.inventory.m_6643_()); ++slot) {
                    ItemStack contents = this.lastValidInventory.m_8020_(slot);
                    if (contents.m_41619_()) continue;
                    this.inventory.m_6836_(slot, contents);
                    this.lastValidInventory.m_6836_(slot, ItemStack.f_41583_);
                }
                if (slot < this.lastValidInventory.m_6643_()) {
                    InventoryHelpers.dropItems((Level)this.m_58904_(), (Container)this.lastValidInventory, (BlockPos)this.m_58899_());
                }
                this.lastValidInventory = null;
            }
        } else {
            this.interfaceLocations.clear();
            if (this.inventory != null) {
                if (GeneralConfig.ejectItemsOnDestroy) {
                    InventoryHelpers.dropItems((Level)this.m_58904_(), (Container)this.inventory, (BlockPos)this.m_58899_());
                    this.lastValidInventory = null;
                } else {
                    this.lastValidInventory = this.inventory;
                }
            }
            this.setInventory((SimpleInventory)new LargeInventory(0, 0));
        }
        this.onDirty();
        BlockHelpers.markForUpdate((Level)this.m_58904_(), (BlockPos)this.m_58899_());
    }

    public void setMaterial(ChestMaterial material) {
        this.materialId = material.ordinal();
    }

    public ChestMaterial getMaterial() {
        return ChestMaterial.VALUES.get(this.materialId);
    }

    public SimpleInventory getLastValidInventory() {
        return this.lastValidInventory;
    }

    public void setLastValidInventory(SimpleInventory lastValidInventory) {
        this.lastValidInventory = lastValidInventory;
    }

    public int getSizeSingular() {
        return this.getSize().m_123341_() + 1;
    }

    protected boolean isClientSide() {
        return this.m_58904_() != null && this.m_58904_().f_46443_;
    }

    protected LargeInventory constructInventory() {
        if (!this.isClientSide() && GeneralConfig.creativeChests) {
            return this.constructInventoryDebug();
        }
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64){

            public void m_5856_(Player entityPlayer) {
                if (!entityPlayer.m_5833_()) {
                    super.m_5856_(entityPlayer);
                    BlockEntityColossalChest.this.startOpen(entityPlayer);
                }
            }

            public void m_5785_(Player entityPlayer) {
                if (!entityPlayer.m_5833_()) {
                    super.m_5785_(entityPlayer);
                    BlockEntityColossalChest.this.stopOpen(entityPlayer);
                }
            }

            public boolean m_6542_(Player entityplayer) {
                return super.m_6542_(entityplayer) && BlockEntityColossalChest.this.f_58857_.m_7702_(BlockEntityColossalChest.this.f_58858_) == BlockEntityColossalChest.this;
            }
        } : new LargeInventory(this.calculateInventorySize(), 64);
        inv.addDirtyMarkListener((IDirtyMarkListener)this);
        return inv;
    }

    protected LargeInventory constructInventoryDebug() {
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64) : new LargeInventory(this.calculateInventorySize(), 64);
        Random random = new Random();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            inv.m_6836_(i, new ItemStack((ItemLike)Iterables.get((Iterable)ForgeRegistries.ITEMS.getValues(), (int)random.nextInt(ForgeRegistries.ITEMS.getValues().size()))));
        }
        return inv;
    }

    public CompoundTag m_5995_() {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        this.inventory = null;
        this.lastValidInventory = null;
        this.recreateNullInventory = false;
        CompoundTag tag = super.m_5995_();
        this.inventory = oldInventory;
        this.lastValidInventory = oldLastInventory;
        this.recreateNullInventory = true;
        return tag;
    }

    public void read(CompoundTag tag) {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.inventory = null;
            this.lastValidInventory = null;
            this.recreateNullInventory = false;
        }
        super.read(tag);
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.inventory = oldInventory;
            this.lastValidInventory = oldLastInventory;
            this.recreateNullInventory = true;
        } else {
            this.getInventory().read(tag.m_128469_("inventory"));
            if (tag.m_128425_("lastValidInventory", 10)) {
                this.lastValidInventory = new LargeInventory(tag.m_128451_("lastValidInventorySize"), this.inventory.m_6893_());
                this.lastValidInventory.read(tag.m_128469_("lastValidInventory"));
            }
        }
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag subTag;
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (this.inventory != null) {
            subTag = new CompoundTag();
            this.inventory.write(subTag);
            tag.m_128365_("inventory", (Tag)subTag);
        }
        if (this.lastValidInventory != null) {
            subTag = new CompoundTag();
            this.lastValidInventory.write(subTag);
            tag.m_128365_("lastValidInventory", (Tag)subTag);
            tag.m_128405_("lastValidInventorySize", this.lastValidInventory.m_6643_());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> this.m_5995_());
    }

    protected int calculateInventorySize() {
        int size = this.getSizeSingular();
        if (size == 1) {
            return 0;
        }
        return (int)Math.ceil(Math.pow(size, 3.0) * 27.0 * this.getMaterial().getInventoryMultiplier() / 9.0) * 9;
    }

    public void setInventory(SimpleInventory inventory) {
        this.capabilityItemHandler.invalidate();
        this.inventory = inventory;
        if (this.inventory.m_6643_() > 0) {
            InvWrapper itemHandler = new InvWrapper((Container)this.inventory);
            this.capabilityItemHandler = LazyOptional.of(() -> BlockEntityColossalChest.lambda$setInventory$1((IItemHandler)itemHandler));
        } else {
            this.capabilityItemHandler = LazyOptional.empty();
        }
    }

    protected void ensureInventoryInitialized() {
        if (this.m_58904_() != null && this.m_58904_().f_46443_ && (this.inventory == null || this.inventory.m_6643_() != this.calculateInventorySize())) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
    }

    public INBTInventory getInventory() {
        if (this.lastValidInventory != null) {
            return new IndexedInventory();
        }
        this.ensureInventoryInitialized();
        if (this.inventory == null && this.recreateNullInventory) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        this.ensureInventoryInitialized();
        if (this.capabilityItemHandler.isPresent() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.capabilityItemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean canInteractWith(Player entityPlayer) {
        return this.getSizeSingular() > 1 && super.canInteractWith(entityPlayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        int size = this.getSizeSingular();
        return new AABB(this.m_58899_().m_121996_(new Vec3i(size, size, size)), this.m_58899_().m_7918_(size, size * 2, size));
    }

    public void setCenter(Vec3 center) {
        double dx = Math.abs(center.f_82479_ - (double)this.m_58899_().m_123341_());
        double dz = Math.abs(center.f_82481_ - (double)this.m_58899_().m_123343_());
        boolean equal = center.f_82479_ - (double)this.m_58899_().m_123341_() == center.f_82481_ - (double)this.m_58899_().m_123343_();
        Direction rotation = dx > dz || !equal && this.getSizeSingular() == 2 ? DirectionHelpers.getEnumFacingFromXSign((int)((int)Math.round(center.f_82479_ - (double)this.m_58899_().m_123341_()))) : DirectionHelpers.getEnumFacingFromZSing((int)((int)Math.round(center.f_82481_ - (double)this.m_58899_().m_123343_())));
        this.setRotation(rotation);
        this.renderOffset = new Vec3((double)this.m_58899_().m_123341_() - center.f_82479_, (double)this.m_58899_().m_123342_() - center.f_82480_, (double)this.m_58899_().m_123343_() - center.f_82481_);
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation.ordinal();
    }

    public Direction getRotation() {
        return Direction.m_122376_((int)this.rotation);
    }

    public Vec3 getRenderOffset() {
        return this.renderOffset;
    }

    public void setRenderOffset(Vec3 renderOffset) {
        this.renderOffset = renderOffset;
    }

    public static void detectStructure(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)Vec3i.f_123288_);
    }

    public static Vec3i getMaxSize() {
        int size = ColossalChestConfig.maxSize - 1;
        return new Vec3i(size, size, size);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public void addInterface(Vec3i blockPos) {
        this.interfaceLocations.add(blockPos);
    }

    public List<Vec3i> getInterfaceLocations() {
        return Collections.unmodifiableList(this.interfaceLocations);
    }

    public Component m_5446_() {
        return this.hasCustomName() ? this.customName : Component.m_237110_((String)"general.colossalchests.colossalchest", (Object[])new Object[]{Component.m_237115_((String)this.getMaterial().getUnlocalizedName()), this.getSizeSingular()});
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerColossalChest(id, playerInventory, (Container)this.getInventory());
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent, int size) {
        float increaseAngle = 0.15f / (float)Math.min(5, size);
        level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, (float)(0.5 + 0.5 * Math.log(size)), level.f_46441_.m_188501_() * 0.1f + 0.45f + increaseAngle);
    }

    public boolean m_7531_(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(eventType, value);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.m_60734_();
        level.m_7696_(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityColossalChest blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public float m_6683_(float value) {
        return this.chestLidController.m_155375_(value);
    }

    private static /* synthetic */ IItemHandler lambda$setInventory$1(IItemHandler itemHandler) {
        return itemHandler;
    }
}

