/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.datagen;

import gisellevonbingen.mmp.common.datagen.BlockTagsGenerator;
import gisellevonbingen.mmp.common.integration.MMPIntagrations;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemTagsGenerator
extends ItemTagsProvider {
    protected final BlockTagsGenerator blockTagGenerator;

    public ItemTagsGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsGenerator blockTagsGenerator, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagsGenerator.m_274426_(), "moremekanismprocessing", existingFileHelper);
        this.blockTagGenerator = blockTagsGenerator;
    }

    protected void m_6577_(HolderLookup.Provider lookupProvider) {
        this.buildStatedMaterials();
        MMPIntagrations.getMods().forEach(m -> m.addItemTags(this));
        this.copyTags();
    }

    protected void buildStatedMaterials() {
        for (MaterialType materialType : MaterialType.values()) {
            for (MaterialState materialState : materialType.getResultShape().getProcessableStates()) {
                IntrinsicHolderTagsProvider.IntrinsicTagAppender builderCategory = this.m_206424_(materialState.getCategoryTag());
                IntrinsicHolderTagsProvider.IntrinsicTagAppender builderState = this.m_206424_(materialState.getStateItemTag(materialType));
                if (!materialState.hasOwnItem()) continue;
                ResourceLocation itemName = materialState.getItemName(materialType);
                builderCategory.m_176839_(itemName);
                builderState.m_176839_(itemName);
            }
        }
    }

    protected void copyTags() {
        this.blockTagGenerator.streamTags().forEach(blockTag -> {
            TagKey itemTag = ItemTags.create((ResourceLocation)blockTag.f_203868_());
            this.m_206421_((TagKey)blockTag, itemTag);
        });
    }

    public void tagOptional(TagKey<Item> tag, ResourceLocation blockName) {
        this.m_206424_(tag).m_176839_(blockName);
    }
}

