/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public abstract class RecipeBuilder {
    private final ResourceLocation id;
    private String group;
    private final List<ICondition> conditions;

    public RecipeBuilder(ResourceLocation id) {
        this.id = id;
        this.conditions = new ArrayList<ICondition>();
        this.setGroup("");
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public void addCondition(ICondition condition) {
        this.conditions.add(condition);
    }

    public static abstract class RecipeResult
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final List<ICondition> conditions;

        public RecipeResult(RecipeBuilder builder) {
            this(builder, builder.id);
        }

        public RecipeResult(RecipeBuilder builder, ResourceLocation id) {
            this.id = id;
            this.group = builder.group;
            this.conditions = new ArrayList<ICondition>(builder.conditions);
        }

        public void m_7917_(JsonObject json) {
            if (!Strings.isNullOrEmpty((String)this.group)) {
                json.addProperty("group", this.group);
            }
            if (!this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                json.add("conditions", (JsonElement)conditionsArray);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public String getGroup() {
            return this.group;
        }

        public List<ICondition> getConditions() {
            return new ArrayList<ICondition>(this.conditions);
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

