/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AffixCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_AFFIX = (ctx, builder) -> SharedSuggestionProvider.m_82981_(AffixRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_APPLICABLE_AFFIX = (ctx, builder) -> {
        LivingEntity living;
        ItemStack held;
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (entity instanceof LivingEntity && !(held = (living = (LivingEntity)entity).m_21205_()).m_41619_()) {
            LootCategory cat = LootCategory.forItem(held);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!cat.isNone() && rarity.isBound()) {
                Stream<String> suggestions = AffixRegistry.INSTANCE.getValues().stream().filter(a -> a.canApplyTo(held, cat, (LootRarity)rarity.get())).map(arg_0 -> ((AffixRegistry)AffixRegistry.INSTANCE).getKey(arg_0)).map(ResourceLocation::toString);
                return SharedSuggestionProvider.m_82981_(suggestions, (SuggestionsBuilder)builder);
            }
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_AFFIX_ON_ITEM = (ctx, builder) -> {
        LivingEntity living;
        ItemStack held;
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (entity instanceof LivingEntity && !(held = (living = (LivingEntity)entity).m_21205_()).m_41619_()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            return SharedSuggestionProvider.m_82981_(affixes.keySet().stream().map(DynamicHolder::getId).map(ResourceLocation::toString), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    };

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"affix").requires(c -> c.m_6761_(2));
        builder.then(Commands.m_82127_((String)"apply").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"affix", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_APPLICABLE_AFFIX).then(Commands.m_82129_((String)"level", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(c -> AffixCommand.applyAffix((CommandContext<CommandSourceStack>)c, ResourceLocationArgument.m_107011_((CommandContext)c, (String)"affix"), FloatArgumentType.getFloat((CommandContext)c, (String)"level"))))).executes(c -> AffixCommand.applyAffix((CommandContext<CommandSourceStack>)c, ResourceLocationArgument.m_107011_((CommandContext)c, (String)"affix"), ((CommandSourceStack)c.getSource()).m_81372_().f_46441_.m_188501_()))));
        builder.then(Commands.m_82127_((String)"list").executes(AffixCommand::listAffixes));
        builder.then(Commands.m_82127_((String)"list_alternatives").then(Commands.m_82129_((String)"affix", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_AFFIX_ON_ITEM).executes(c -> AffixCommand.listAlternatives((CommandContext<CommandSourceStack>)c, ResourceLocationArgument.m_107011_((CommandContext)c, (String)"affix")))));
        root.then((ArgumentBuilder)builder);
    }

    public static int applyAffix(CommandContext<CommandSourceStack> c, ResourceLocation affixId, float level) {
        DynamicHolder afx = AffixRegistry.INSTANCE.holder(affixId);
        if (!afx.isBound()) {
            return AffixCommand.fail(c, "Unknown affix: " + String.valueOf(affixId), -1);
        }
        Entity entity = ((CommandSourceStack)c.getSource()).m_81373_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack held = living.m_21205_();
            if (held.m_41619_()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            LootCategory cat = LootCategory.forItem(held);
            if (cat.isNone()) {
                return AffixCommand.fail(c, "The target item must have a valid loot category", -4);
            }
            if (!((Affix)afx.get()).canApplyTo(held, cat, (LootRarity)rarity.get())) {
                return AffixCommand.fail(c, "The selected affix cannot be applied to the target item.", -5);
            }
            AffixHelper.applyAffix(held, new AffixInstance((DynamicHolder<? extends Affix>)afx, held, rarity, level));
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237110_((String)"Successfully applied affix %s with level %s to %s", (Object[])new Object[]{affixId, Float.valueOf(level), held.m_41611_()}), true);
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int listAffixes(CommandContext<CommandSourceStack> c) {
        Entity entity = ((CommandSourceStack)c.getSource()).m_81373_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack held = living.m_21205_();
            if (held.m_41619_()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            ((CommandSourceStack)c.getSource()).m_243053_((Component)Component.m_237110_((String)"Affixes present on %s:", (Object[])new Object[]{held.m_41611_()}));
            affixes.forEach((afx, inst) -> {
                MutableComponent name = Component.m_237110_((String)"[%s]", (Object[])new Object[]{inst.getName(true)});
                name.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)inst.getAugmentingText())));
                ((CommandSourceStack)c.getSource()).m_243053_((Component)Component.m_237110_((String)"%s - %s%%", (Object[])new Object[]{name, Affix.fmt(100.0f * inst.level())}));
            });
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int listAlternatives(CommandContext<CommandSourceStack> c, ResourceLocation affixId) {
        DynamicHolder afx = AffixRegistry.INSTANCE.holder(affixId);
        if (!afx.isBound()) {
            return AffixCommand.fail(c, "Unknown affix: " + String.valueOf(affixId), -1);
        }
        Entity entity = ((CommandSourceStack)c.getSource()).m_81373_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack held = living.m_21205_();
            if (held.m_41619_()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            if (!affixes.containsKey(afx)) {
                return AffixCommand.fail(c, "The target item does not contain the selected affix.", -4);
            }
            List<DynamicHolder<? extends Affix>> alternatives = LootController.getAvailableAffixes(held, (LootRarity)rarity.get(), affixes.keySet(), ((Affix)afx.get()).getType());
            ((CommandSourceStack)c.getSource()).m_243053_((Component)Component.m_237110_((String)"Possible alternatives to %s:", (Object[])new Object[]{((Affix)afx.get()).getName(true)}));
            alternatives.forEach(a -> {
                MutableComponent name = Component.m_237110_((String)"[%s]", (Object[])new Object[]{((Affix)a.get()).getName(true)});
                Component augTxt = ((Affix)a.get()).getAugmentingText(held, (LootRarity)rarity.get(), 0.5f);
                name.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)augTxt)));
                ((CommandSourceStack)c.getSource()).m_243053_((Component)AttributeHelper.list().m_7220_((Component)name));
            });
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int fail(CommandContext<CommandSourceStack> c, String msg, int code) {
        ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237115_((String)msg));
        return code;
    }
}

