/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer.networking;

import jackiecrazy.attributizer.ArmorAttributizer;
import jackiecrazy.attributizer.MainHandAttributizer;
import jackiecrazy.attributizer.OffhandAttributizer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncItemDataPacket {
    private static final FriendlyByteBuf.Writer<Item> item = (f, item) -> f.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)));
    private static final FriendlyByteBuf.Writer<Map<Attribute, List<AttributeModifier>>> info = (f, info) -> f.m_236831_(info, (ff, a) -> ff.m_130085_(ForgeRegistries.ATTRIBUTES.getKey(a)), (ff, b) -> ff.m_236828_((Collection)b, (fbb, am) -> {
        fbb.m_130077_(am.m_22209_());
        fbb.writeDouble(am.m_22218_());
        fbb.writeByte(am.m_22217_().m_22235_());
    }));
    private static final FriendlyByteBuf.Reader<Item> ritem = friendlyByteBuf -> (Item)ForgeRegistries.ITEMS.getValue(friendlyByteBuf.m_130281_());
    private static final FriendlyByteBuf.Reader<Map<Attribute, List<AttributeModifier>>> rinfo = f -> f.m_236847_(ff -> (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ff.m_130281_()), ff -> ff.m_236845_(p_179457_ -> new AttributeModifier(p_179457_.m_130259_(), "Attributizer tag modifier", p_179457_.readDouble(), AttributeModifier.Operation.m_22236_((int)p_179457_.readByte()))));
    private final Map<Item, Map<Attribute, List<AttributeModifier>>> map;
    private final int type;

    public SyncItemDataPacket(int type, Map<Item, Map<Attribute, List<AttributeModifier>>> map) {
        this.type = type;
        this.map = map;
    }

    public static class Handler
    implements BiConsumer<SyncItemDataPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(SyncItemDataPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            if (contextSupplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                contextSupplier.get().enqueueWork(() -> {
                    switch (updateClientPacket.type) {
                        case 0: {
                            MainHandAttributizer.clientDataOverride(updateClientPacket.map);
                            break;
                        }
                        case 1: {
                            OffhandAttributizer.clientDataOverride(updateClientPacket.map);
                            break;
                        }
                        case 2: {
                            ArmorAttributizer.clientDataOverride(updateClientPacket.map);
                        }
                    }
                });
            }
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, SyncItemDataPacket> {
        @Override
        public SyncItemDataPacket apply(FriendlyByteBuf packetBuffer) {
            return new SyncItemDataPacket(packetBuffer.readInt(), packetBuffer.m_236847_(ritem, rinfo));
        }
    }

    public static class Encoder
    implements BiConsumer<SyncItemDataPacket, FriendlyByteBuf> {
        @Override
        public void accept(SyncItemDataPacket packet, FriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(packet.type);
            packetBuffer.m_236831_(packet.map, item, info);
        }
    }
}

