/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer.networking;

import jackiecrazy.attributizer.ArmorAttributizer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncArmorTagDataPacket {
    private static final FriendlyByteBuf.Writer<TagKey<Item>> item = (f, item) -> f.m_130085_(item.f_203868_());
    private static final FriendlyByteBuf.Writer<Map<Attribute, List<AttributeModifier[]>>> info = (f, info) -> f.m_236831_(info, (ff, a) -> ff.m_130085_(ForgeRegistries.ATTRIBUTES.getKey(a)), (ff, b) -> ff.m_236828_((Collection)b, (fbb, al) -> {
        for (AttributeModifier am : al) {
            fbb.m_130077_(am.m_22209_());
            fbb.writeDouble(am.m_22218_());
            fbb.writeByte(am.m_22217_().m_22235_());
        }
    }));
    private static final FriendlyByteBuf.Reader<TagKey<Item>> ritem = f -> ItemTags.create((ResourceLocation)f.m_130281_());
    private static final FriendlyByteBuf.Reader<Map<Attribute, List<AttributeModifier[]>>> rinfo = f -> f.m_236847_(ff -> (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ff.m_130281_()), ff -> ff.m_236845_(p_179457_ -> {
        AttributeModifier[] ret = new AttributeModifier[4];
        for (int x = 0; x < ret.length; ++x) {
            ret[x] = new AttributeModifier(p_179457_.m_130259_(), "Attributizer armor tag modifier", p_179457_.readDouble(), AttributeModifier.Operation.m_22236_((int)p_179457_.readByte()));
        }
        return ret;
    }));
    private final Map<TagKey<Item>, Map<Attribute, List<AttributeModifier[]>>> map;

    public SyncArmorTagDataPacket(Map<TagKey<Item>, Map<Attribute, List<AttributeModifier[]>>> map) {
        this.map = map;
    }

    public static class Handler
    implements BiConsumer<SyncArmorTagDataPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(SyncArmorTagDataPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            if (contextSupplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                contextSupplier.get().enqueueWork(() -> ArmorAttributizer.clientTagOverride(updateClientPacket.map));
            }
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, SyncArmorTagDataPacket> {
        @Override
        public SyncArmorTagDataPacket apply(FriendlyByteBuf packetBuffer) {
            return new SyncArmorTagDataPacket(packetBuffer.m_236847_(ritem, rinfo));
        }
    }

    public static class Encoder
    implements BiConsumer<SyncArmorTagDataPacket, FriendlyByteBuf> {
        @Override
        public void accept(SyncArmorTagDataPacket packet, FriendlyByteBuf packetBuffer) {
            packetBuffer.m_236831_(packet.map, item, info);
        }
    }
}

