/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer;

import com.mojang.logging.LogUtils;
import jackiecrazy.attributizer.ArmorAttributizer;
import jackiecrazy.attributizer.EntityAttributizer;
import jackiecrazy.attributizer.MainHandAttributizer;
import jackiecrazy.attributizer.OffhandAttributizer;
import jackiecrazy.attributizer.networking.AttributeChannel;
import jackiecrazy.attributizer.networking.SyncArmorTagDataPacket;
import jackiecrazy.attributizer.networking.SyncItemDataPacket;
import jackiecrazy.attributizer.networking.SyncTagDataPacket;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="attributizer")
public class Attributizer {
    public static final String MODID = "attributizer";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Attributizer() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        int index = 0;
        AttributeChannel.INSTANCE.registerMessage(index++, SyncItemDataPacket.class, (BiConsumer)new SyncItemDataPacket.Encoder(), (Function)new SyncItemDataPacket.Decoder(), (BiConsumer)new SyncItemDataPacket.Handler());
        AttributeChannel.INSTANCE.registerMessage(index++, SyncTagDataPacket.class, (BiConsumer)new SyncTagDataPacket.Encoder(), (Function)new SyncTagDataPacket.Decoder(), (BiConsumer)new SyncTagDataPacket.Handler());
        AttributeChannel.INSTANCE.registerMessage(index++, SyncArmorTagDataPacket.class, (BiConsumer)new SyncArmorTagDataPacket.Encoder(), (Function)new SyncArmorTagDataPacket.Decoder(), (BiConsumer)new SyncArmorTagDataPacket.Handler());
    }

    @Mod.EventBusSubscriber
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onJsonListener(AddReloadListenerEvent event) {
            ArmorAttributizer.register(event);
            MainHandAttributizer.register(event);
            OffhandAttributizer.register(event);
            EntityAttributizer.register(event);
        }

        @SubscribeEvent
        public static void login(PlayerEvent.PlayerLoggedInEvent e) {
            Player player = e.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                MainHandAttributizer.sendItemData(sp);
                OffhandAttributizer.sendItemData(sp);
                ArmorAttributizer.sendItemData(sp);
            }
        }

        @SubscribeEvent
        public static void reload(OnDatapackSyncEvent e) {
            for (ServerPlayer sp : e.getPlayerList().m_11314_()) {
                MainHandAttributizer.sendItemData(sp);
                OffhandAttributizer.sendItemData(sp);
                ArmorAttributizer.sendItemData(sp);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void mobs(EntityJoinLevelEvent e) {
            Entity entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity elb = (LivingEntity)entity;
                if (!e.loadedFromDisk()) {
                    if (!(elb instanceof Player)) {
                        EntityAttributizer.GLOBALMAP.forEach((k, v) -> v.forEach(am -> {
                            AttributeInstance ai = elb.m_21051_(k);
                            if (ai != null) {
                                am.applyModifier(ai);
                            }
                        }));
                    }
                    if (EntityAttributizer.MAP.containsKey(e.getEntity().m_6095_())) {
                        Map<Attribute, List<EntityAttributizer.AttributeMod>> map = EntityAttributizer.MAP.get(elb.m_6095_());
                        map.forEach((k, v) -> v.forEach(am -> {
                            AttributeInstance ai = elb.m_21051_(k);
                            if (ai != null) {
                                am.applyModifier(ai);
                            }
                        }));
                    }
                    EntityAttributizer.ARCHETYPES.forEach((k, v) -> {
                        if (elb.m_6095_().m_204039_(k)) {
                            v.forEach((a, b) -> b.forEach(am -> {
                                AttributeInstance ai = elb.m_21051_(a);
                                if (ai != null) {
                                    am.applyModifier(ai);
                                }
                            }));
                        }
                    });
                }
            }
        }

        @SubscribeEvent
        public static void items(ItemAttributeModifierEvent e) {
            Map<Attribute, List<AttributeModifier>> map;
            if (e.getItemStack().m_41619_()) {
                return;
            }
            if (!e.getOriginalModifiers().isEmpty()) {
                if (ArmorAttributizer.MAP.containsKey(e.getItemStack().m_41720_())) {
                    map = ArmorAttributizer.MAP.get(e.getItemStack().m_41720_());
                    RegistryEvents.apply(e, map);
                } else if (ArmorAttributizer.CACHEMAP.containsKey(e.getItemStack().m_41720_())) {
                    ArmorAttributizer.CACHEMAP.computeIfPresent(e.getItemStack().m_41720_(), (item, tag) -> {
                        ArmorAttributizer.ARCHETYPES.computeIfPresent((TagKey<Item>)tag, (tag1, attr) -> {
                            attr.forEach((l, m) -> m.forEach(am -> e.addModifier(l, am[e.getSlotType().m_20749_()])));
                            return attr;
                        });
                        return tag;
                    });
                } else {
                    ArmorAttributizer.ARCHETYPES.entrySet().stream().filter(k -> e.getItemStack().m_204117_((TagKey)k.getKey())).findFirst().ifPresent(k -> {
                        if (e.getItemStack().m_204117_((TagKey)k.getKey())) {
                            ((Map)k.getValue()).forEach((l, m) -> m.forEach(am -> e.addModifier(l, am[e.getSlotType().m_20749_()])));
                            ArmorAttributizer.CACHEMAP.put(e.getItemStack().m_41720_(), (TagKey<Item>)((TagKey)k.getKey()));
                        }
                    });
                }
            }
            if (e.getSlotType() == EquipmentSlot.OFFHAND) {
                if (OffhandAttributizer.MAP.containsKey(e.getItemStack().m_41720_())) {
                    map = OffhandAttributizer.MAP.get(e.getItemStack().m_41720_());
                    RegistryEvents.apply(e, map);
                } else if (OffhandAttributizer.CACHEMAP.containsKey(e.getItemStack().m_41720_())) {
                    RegistryEvents.apply(e, OffhandAttributizer.ARCHETYPES.get(OffhandAttributizer.CACHEMAP.get(e.getItemStack().m_41720_())));
                } else {
                    OffhandAttributizer.ARCHETYPES.entrySet().stream().filter(k -> e.getItemStack().m_204117_((TagKey)k.getKey())).findFirst().ifPresent(k -> {
                        RegistryEvents.apply(e, (Map)k.getValue());
                        OffhandAttributizer.CACHEMAP.put(e.getItemStack().m_41720_(), (TagKey<Item>)((TagKey)k.getKey()));
                    });
                }
            }
            if (e.getSlotType() == EquipmentSlot.MAINHAND) {
                if (MainHandAttributizer.MAP.containsKey(e.getItemStack().m_41720_())) {
                    map = MainHandAttributizer.MAP.get(e.getItemStack().m_41720_());
                    RegistryEvents.apply(e, map);
                } else if (MainHandAttributizer.CACHEMAP.containsKey(e.getItemStack().m_41720_())) {
                    RegistryEvents.apply(e, MainHandAttributizer.ARCHETYPES.get(MainHandAttributizer.CACHEMAP.get(e.getItemStack().m_41720_())));
                } else {
                    MainHandAttributizer.ARCHETYPES.entrySet().stream().filter(k -> e.getItemStack().m_204117_((TagKey)k.getKey())).findFirst().ifPresent(k -> {
                        RegistryEvents.apply(e, (Map)k.getValue());
                        MainHandAttributizer.CACHEMAP.put(e.getItemStack().m_41720_(), (TagKey<Item>)((TagKey)k.getKey()));
                    });
                }
            }
        }

        private static void apply(ItemAttributeModifierEvent e, Map<Attribute, List<AttributeModifier>> map) {
            map.forEach((k, v) -> v.forEach(am -> e.addModifier(k, am)));
        }
    }
}

