/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jackiecrazy.attributizer.Attributizer;
import jackiecrazy.attributizer.networking.AttributeChannel;
import jackiecrazy.attributizer.networking.SyncArmorTagDataPacket;
import jackiecrazy.attributizer.networking.SyncItemDataPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorAttributizer
extends SimpleJsonResourceReloadListener {
    public static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("a516026a-bee2-4014-bcb6-b6a5775553da"), UUID.fromString("a516026a-bee2-4014-bcb6-b6a5775553db"), UUID.fromString("a516026a-bee2-4014-bcb6-b6a5775553dc"), UUID.fromString("a516026a-bee2-4014-bcb6-b6a5775553dd"), UUID.fromString("a516026a-bee2-4014-bcb6-b6a5775553de"), UUID.fromString("a516026a-bee2-4014-bcb6-b6a5775553df")};
    public static final Map<Item, Map<Attribute, List<AttributeModifier>>> MAP = new HashMap<Item, Map<Attribute, List<AttributeModifier>>>();
    public static final Map<Item, TagKey<Item>> CACHEMAP = new HashMap<Item, TagKey<Item>>();
    public static final Map<TagKey<Item>, Map<Attribute, List<AttributeModifier[]>>> ARCHETYPES = new HashMap<TagKey<Item>, Map<Attribute, List<AttributeModifier[]>>>();
    public static Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();

    public static void clientDataOverride(Map<Item, Map<Attribute, List<AttributeModifier>>> server) {
        MAP.putAll(server);
    }

    public static void clientTagOverride(Map<TagKey<Item>, Map<Attribute, List<AttributeModifier[]>>> server) {
        ARCHETYPES.putAll(server);
    }

    public static void sendItemData(ServerPlayer p) {
        Set paths = MAP.keySet().stream().map(a -> ForgeRegistries.ITEMS.getKey(a).m_135827_()).collect(Collectors.toSet());
        for (String namespace : paths) {
            AttributeChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)new SyncItemDataPacket(2, Maps.filterEntries(MAP, a -> ForgeRegistries.ITEMS.getKey((Object)((Item)a.getKey())).m_135827_().equals(namespace))));
        }
        AttributeChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)new SyncArmorTagDataPacket(ARCHETYPES));
    }

    public ArmorAttributizer() {
        super(GSON, "attributizer/armor");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ArmorAttributizer());
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager rm, ProfilerFiller profiler) {
        MAP.clear();
        CACHEMAP.clear();
        ARCHETYPES.clear();
        object.forEach((key, value) -> {
            JsonObject file = value.getAsJsonObject();
            file.entrySet().forEach(entry -> {
                ResourceLocation i;
                boolean isTag = false;
                Object name = (String)entry.getKey();
                Item item = null;
                if (((String)name).startsWith("#")) {
                    isTag = true;
                    if (!((String)(name = ((String)name).substring(1))).contains(":")) {
                        name = "attributizer:" + (String)name;
                    }
                }
                if (!((item = (Item)ForgeRegistries.ITEMS.getValue(i = new ResourceLocation((String)name))) != null && item != Items.f_41852_ || isTag)) {
                    Attributizer.LOGGER.debug((String)name + " is not a registered item!");
                    return;
                }
                JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement e : array) {
                    try {
                        UUID uid;
                        Map<Attribute, List<AttributeModifier[]>> sub;
                        JsonObject obj = e.getAsJsonObject();
                        ResourceLocation attribute = new ResourceLocation(obj.get("attribute").getAsString());
                        Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attribute);
                        if (a == null) {
                            Attributizer.LOGGER.debug(attribute + " is not a registered attribute!");
                            continue;
                        }
                        double modify = obj.get("modify").getAsDouble();
                        String type = obj.get("operation").getAsString();
                        if (isTag) {
                            AttributeModifier[] insert = new AttributeModifier[MODIFIERS.length];
                            for (int b = 0; b < MODIFIERS.length; ++b) {
                                AttributeModifier am;
                                insert[b] = am = new AttributeModifier(MODIFIERS[b], "attributizer change", modify, AttributeModifier.Operation.valueOf((String)type));
                            }
                            TagKey tag = ItemTags.create((ResourceLocation)i);
                            ARCHETYPES.putIfAbsent((TagKey<Item>)tag, new HashMap());
                            sub = ARCHETYPES.get(tag);
                            sub.putIfAbsent(a, new ArrayList());
                            sub.get(a).add(insert);
                            ARCHETYPES.put((TagKey<Item>)tag, sub);
                        }
                        try {
                            String u = obj.get("uuid").getAsString();
                            uid = UUID.fromString(u);
                        }
                        catch (Exception ignored) {
                            if (item instanceof ArmorItem) {
                                ArmorItem armor = (ArmorItem)item;
                                uid = MODIFIERS[armor.m_40402_().m_20749_()];
                            }
                            uid = item instanceof ShieldItem ? MODIFIERS[5] : MODIFIERS[4];
                        }
                        AttributeModifier am = new AttributeModifier(uid, "attributizer change", modify, AttributeModifier.Operation.valueOf((String)type));
                        MAP.putIfAbsent(item, new HashMap());
                        sub = MAP.get(item);
                        sub.putIfAbsent(a, new ArrayList());
                        sub.get(a).add((AttributeModifier[])am);
                        MAP.put(item, sub);
                    }
                    catch (Exception x) {
                        Attributizer.LOGGER.error("incomplete or malformed json under " + (String)name + "!");
                        x.printStackTrace();
                    }
                }
            });
        });
    }

    public static class AttributeMod {
        public UUID uid;
        public double mod;
        public ResourceLocation attr;
    }
}

