/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.test;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.Quartz;
import net.roguelogix.quartz.QuartzEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuartzTestBlockTile
extends PhosphophylliteTile {
    @RegisterTile(value="quartz_test_block")
    public static final BlockEntityType.BlockEntitySupplier<QuartzTestBlockTile> SUPPLIER = new RegisterTile.Producer(QuartzTestBlockTile::new);
    private static Mesh mesh;
    private DrawBatch.Instance instance = null;

    public QuartzTestBlockTile(BlockEntityType<?> TYPE, BlockPos pWorldPosition, BlockState pBlockState) {
        super(TYPE, pWorldPosition, pBlockState);
    }

    private static void onQuartzStartup(QuartzEvent.Startup quartzStartup) {
        mesh = Quartz.createStaticMesh(Blocks.f_50069_.m_49966_());
    }

    public void onAdded() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
            return;
        }
        if (mesh != null && this.f_58857_.m_5776_()) {
            Vector3i modelPos = new Vector3i(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_());
            DrawBatch batcher = Quartz.getDrawBatcherForBlock((Vector3ic)modelPos);
            Matrix4f initialValueMatrix = new Matrix4f();
            initialValueMatrix.scale(0.5f);
            initialValueMatrix.translate(0.5f, 0.5f, 0.5f);
            DynamicMatrix quartzMatrix = batcher.createDynamicMatrix((Matrix4fc)initialValueMatrix, (matrix, nanoSinceLastFrame, partialTicks, playerBlock, playerPartialBlock) -> {
                float rotation = (float)nanoSinceLastFrame / 1.0E9f;
                matrix.translate(0.5f, 0.5f, 0.5f);
                matrix.rotate(rotation, (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f).normalize());
                matrix.translate(-0.5f, -0.5f, -0.5f);
            });
            this.instance = batcher.createInstance((Vector3ic)modelPos, mesh, quartzMatrix, null, null);
        }
    }

    public void onRemoved(boolean chunkUnload) {
        assert (this.f_58857_ != null);
        if (mesh != null && this.f_58857_.m_5776_()) {
            this.instance.delete();
            this.instance = null;
        }
    }

    static {
        Quartz.EVENT_BUS.addListener(QuartzTestBlockTile::onQuartzStartup);
    }
}

