/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.joml.Vector3f;

@NonnullDefault
public class InternalMesh
implements Mesh {
    public Consumer<Mesh.Builder> buildFunc;

    public InternalMesh(Consumer<Mesh.Builder> buildFunc) {
        this.buildFunc = buildFunc;
    }

    public Object2LongArrayMap<RenderType> build(Function<Integer, PointerWrapper> bufferCreator) {
        Builder builder = new Builder();
        this.buildFunc.accept(builder);
        PointerWrapper buffer = bufferCreator.apply(builder.bytesRequired());
        return builder.build(buffer);
    }

    @Override
    public void rebuild() {
        QuartzCore.INSTANCE.meshManager.buildMesh(this);
    }

    private static class Builder
    implements Mesh.Builder,
    MultiBufferSource {
        private final PoseStack poseStack = new PoseStack();
        private final HashMap<RenderType, BufferBuilder> buffers = new HashMap();

        Builder() {
        }

        @Override
        public MultiBufferSource bufferSource() {
            return this;
        }

        @Override
        public PoseStack matrixStack() {
            return this.poseStack;
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            if (!(renderType instanceof RenderType.CompositeRenderType)) {
                throw new IllegalArgumentException("RenderType must be composite type");
            }
            return this.buffers.computeIfAbsent(renderType, e -> new BufferBuilder());
        }

        int bytesRequired() {
            int totalVertices = 0;
            for (Map.Entry<RenderType, BufferBuilder> entry : this.buffers.entrySet()) {
                RenderType renderType = entry.getKey();
                BufferBuilder bufferBuilder = entry.getValue();
                int vertexCount = bufferBuilder.vertices.size() - bufferBuilder.vertices.size() % renderType.m_173186_().f_166947_;
                if (vertexCount == 0) continue;
                totalVertices += vertexCount;
            }
            return totalVertices * 32;
        }

        Object2LongArrayMap<RenderType> build(PointerWrapper masterBuffer) {
            Object2LongArrayMap drawInfoMap = new Object2LongArrayMap();
            int currentByteIndex = 0;
            for (Map.Entry<RenderType, BufferBuilder> entry : this.buffers.entrySet()) {
                RenderType renderType = entry.getKey();
                BufferBuilder bufferBuilder = entry.getValue();
                int vertexCount = bufferBuilder.vertices.size() - bufferBuilder.vertices.size() % renderType.m_173186_().f_166947_;
                if (vertexCount == 0) continue;
                long offsetAndSize = (long)(currentByteIndex / 32) << 32 | (long)vertexCount;
                PointerWrapper typeBuffer = masterBuffer.slice(currentByteIndex, vertexCount * 32);
                currentByteIndex += vertexCount * 32;
                Vector3f tempNormalVec = new Vector3f();
                int vertexIndex = 0;
                for (Vertex vertex : bufferBuilder.vertices) {
                    if (vertexIndex > vertexCount) break;
                    PointerWrapper vertexBuffer = typeBuffer.slice((long)vertexIndex * 32L, 32L);
                    vertexBuffer.putFloatIdx(0L, vertex.x);
                    vertexBuffer.putFloatIdx(1L, vertex.y);
                    vertexBuffer.putFloatIdx(2L, vertex.z);
                    vertexBuffer.putIntIdx(3L, vertex.rgba);
                    vertexBuffer.putFloatIdx(4L, vertex.texU);
                    vertexBuffer.putFloatIdx(5L, vertex.texV);
                    tempNormalVec.set(vertex.normalX, vertex.normalY, vertex.normalZ);
                    tempNormalVec.normalize(32767.0f);
                    vertexBuffer.putShortIdx(12L, (short)tempNormalVec.x);
                    vertexBuffer.putShortIdx(13L, (short)tempNormalVec.y);
                    vertexBuffer.putShortIdx(14L, (short)tempNormalVec.z);
                    ++vertexIndex;
                }
                drawInfoMap.put((Object)renderType, offsetAndSize);
            }
            return drawInfoMap;
        }

        private static int packInt(int value, int position, int width) {
            int signBitMask = 1 << width - 1;
            int bitMask = signBitMask - 1;
            int returnVal = value & bitMask;
            return (returnVal |= value >> 32 - width & signBitMask) << position;
        }

        private static int extractInt(int packed, int pos, int width) {
            int signBitMask = 1 << width - 1;
            int bitMask = signBitMask - 1;
            int val = ~bitMask * ((signBitMask & (packed >>= pos)) != 0 ? 1 : 0);
            return val |= packed & bitMask;
        }

        private static class BufferBuilder
        implements VertexConsumer {
            Vertex currentVertex = new Vertex();
            final LinkedList<Vertex> vertices = new LinkedList();
            private boolean defaultColorSet = false;
            private int drgba;

            private BufferBuilder() {
            }

            public VertexConsumer m_5483_(double x, double y, double z) {
                this.currentVertex.x = (float)x;
                this.currentVertex.y = (float)y;
                this.currentVertex.z = (float)z;
                return this;
            }

            public VertexConsumer m_6122_(int r, int g, int b, int a) {
                this.currentVertex.rgba = a << 24 | b << 16 | g << 8 | r;
                return this;
            }

            public VertexConsumer m_7421_(float u, float v) {
                this.currentVertex.texU = u;
                this.currentVertex.texV = v;
                return this;
            }

            public VertexConsumer m_7122_(int oU, int oV) {
                return this;
            }

            public VertexConsumer m_7120_(int u2, int v2) {
                this.currentVertex.lightmapU = u2;
                this.currentVertex.lightmapV = v2;
                return this;
            }

            public VertexConsumer m_5601_(float nx, float ny, float nz) {
                this.currentVertex.normalX = nx;
                this.currentVertex.normalY = ny;
                this.currentVertex.normalZ = nz;
                return this;
            }

            public void m_5752_() {
                this.vertices.add(this.currentVertex);
                this.currentVertex = new Vertex(this.currentVertex);
                if (this.defaultColorSet) {
                    this.currentVertex.rgba = this.drgba;
                }
            }

            public void m_7404_(int r, int g, int b, int a) {
                this.drgba = a << 24 | b << 16 | g << 8 | r;
                this.defaultColorSet = true;
            }

            public void m_141991_() {
                this.defaultColorSet = false;
            }
        }

        private static class Vertex {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float normalX = 0.0f;
            float normalY = 0.0f;
            float normalZ = 0.0f;
            int rgba = -1;
            float texU = 0.0f;
            float texV = 0.0f;
            int lightmapU = 0;
            int lightmapV = 0;

            Vertex() {
            }

            Vertex(Vertex toCopy) {
                this.x = toCopy.x;
                this.y = toCopy.y;
                this.z = toCopy.z;
                this.normalX = toCopy.normalX;
                this.normalY = toCopy.normalY;
                this.normalZ = toCopy.normalZ;
                this.rgba = toCopy.rgba;
                this.texU = toCopy.texU;
                this.texV = toCopy.texV;
                this.lightmapU = toCopy.lightmapU;
                this.lightmapV = toCopy.lightmapV;
            }
        }
    }

    public static class Manager {
        private final ObjectArrayList<TrackedMesh> trackedMeshes = new ObjectArrayList();
        public final Buffer vertexBuffer;

        public Manager(Buffer vertexBuffer) {
            this.vertexBuffer = vertexBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InternalMesh createMesh(Consumer<Mesh.Builder> buildFunc) {
            InternalMesh staticMesh = new InternalMesh(buildFunc);
            TrackedMesh trackedMesh = new TrackedMesh(new WeakReference<InternalMesh>(staticMesh), this.vertexBuffer);
            ObjectArrayList<TrackedMesh> objectArrayList = this.trackedMeshes;
            synchronized (objectArrayList) {
                this.trackedMeshes.add((Object)trackedMesh);
            }
            QuartzCore.CLEANER.register(staticMesh, () -> {
                ObjectArrayList<TrackedMesh> objectArrayList = this.trackedMeshes;
                synchronized (objectArrayList) {
                    this.trackedMeshes.remove((Object)trackedMesh);
                }
            });
            return staticMesh;
        }

        @Nullable
        public TrackedMesh getMeshInfo(Mesh mesh) {
            for (int i = 0; i < this.trackedMeshes.size(); ++i) {
                TrackedMesh trackedMesh = (TrackedMesh)this.trackedMeshes.get(i);
                if (trackedMesh.meshRef.get() != mesh) continue;
                return trackedMesh;
            }
            return null;
        }

        public void buildAllMeshes() {
            for (TrackedMesh value : this.trackedMeshes) {
                this.buildTrackedMesh(value);
            }
        }

        public void buildMesh(Mesh mesh) {
            TrackedMesh trackedMesh = this.getMeshInfo(mesh);
            if (trackedMesh != null) {
                this.buildTrackedMesh(trackedMesh);
            }
        }

        private void buildTrackedMesh(TrackedMesh trackedMesh) {
            QuartzCore.INSTANCE.waitIdle();
            trackedMesh.rebuild();
        }

        public static class TrackedMesh {
            public final WeakReference<InternalMesh> meshRef;
            private final Buffer vertexBuffer;
            @Nullable
            private Buffer.Allocation vertexAllocation;
            private final Object2ObjectArrayMap<RenderType, Component> drawInfo = new Object2ObjectArrayMap();
            private final ObjectArrayList<Consumer<TrackedMesh>> buildCallbacks = new ObjectArrayList();

            public TrackedMesh(WeakReference<InternalMesh> meshRef, Buffer vertexBuffer) {
                this.meshRef = meshRef;
                this.vertexBuffer = vertexBuffer;
            }

            void rebuild() {
                QuartzCore.INSTANCE.waitIdle();
                InternalMesh mesh = (InternalMesh)this.meshRef.get();
                if (mesh == null) {
                    return;
                }
                this.drawInfo.clear();
                Object2LongArrayMap<RenderType> rawDrawInfo = mesh.build(this::allocBuffer);
                assert (this.vertexAllocation != null);
                this.vertexAllocation.dirty();
                for (Object2LongMap.Entry renderTypeEntry : rawDrawInfo.object2LongEntrySet()) {
                    RenderType renderType = (RenderType)renderTypeEntry.getKey();
                    long drawLong = renderTypeEntry.getLongValue();
                    Component drawComponent = new Component((int)(drawLong >> 32) + this.vertexAllocation.offset() / 32, (int)drawLong);
                    this.drawInfo.put((Object)renderType, (Object)drawComponent);
                }
                for (int i = 0; i < this.buildCallbacks.size(); ++i) {
                    ((Consumer)this.buildCallbacks.get(i)).accept(this);
                }
            }

            private PointerWrapper allocBuffer(int size) {
                this.vertexAllocation = this.vertexAllocation != null ? this.vertexBuffer.realloc(this.vertexAllocation, size, 32, false) : this.vertexBuffer.alloc(size, 32);
                return this.vertexAllocation.address();
            }

            public Collection<RenderType> usedRenderTypes() {
                return this.drawInfo.keySet();
            }

            @Nullable
            public Component renderTypeComponent(RenderType renderType) {
                return (Component)this.drawInfo.get((Object)renderType);
            }

            public void addBuildCallback(Consumer<TrackedMesh> consumer) {
                this.buildCallbacks.add(consumer);
            }

            public void removeBuildCallback(Consumer<TrackedMesh> consumer) {
                this.buildCallbacks.remove(consumer);
            }

            public record Component(int vertexOffset, int vertexCount) {
            }
        }
    }
}

