/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal;

import javax.annotation.Nullable;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;

public class MultiBuffer<T extends Buffer> {
    private final Buffer[] backingBuffers;
    private int activeFrame;

    public MultiBuffer(int framesInFlight, boolean GPUOnly) {
        this.backingBuffers = new Buffer[framesInFlight];
        for (int i = 0; i < this.backingBuffers.length; ++i) {
            this.backingBuffers[i] = QuartzCore.INSTANCE.allocBuffer(GPUOnly);
        }
    }

    public void setActiveFrame(int activeFrame) {
        this.activeFrame = activeFrame % this.backingBuffers.length;
    }

    public int activeFrame() {
        return this.activeFrame;
    }

    public T activeBuffer() {
        return (T)this.backingBuffers[this.activeFrame];
    }

    public T buffer(int frame) {
        return (T)this.backingBuffers[frame % this.backingBuffers.length];
    }

    public Allocation alloc(int size) {
        return this.alloc(size, 1);
    }

    public Allocation alloc(int size, int alignment) {
        Allocation toRet = new Allocation();
        for (int i = 0; i < this.backingBuffers.length; ++i) {
            toRet.backingAllocations[i] = this.backingBuffers[i].alloc(size, alignment);
        }
        return toRet;
    }

    public Allocation realloc(@Nullable Allocation allocation, int newSize, boolean copyData) {
        return this.realloc(allocation, newSize, 1, copyData);
    }

    public Allocation realloc(@Nullable Allocation allocation, int newSize, int alignment, boolean copyData) {
        if (allocation == null) {
            return this.alloc(newSize, alignment);
        }
        for (int i = 0; i < this.backingBuffers.length; ++i) {
            allocation.backingAllocations[i] = this.backingBuffers[i].realloc(allocation.backingAllocations[i], newSize, alignment, copyData);
        }
        return allocation;
    }

    public void free(Allocation allocation) {
        for (int i = 0; i < allocation.backingAllocations.length; ++i) {
            allocation.backingAllocations[i].free();
        }
    }

    public void dirtyAll() {
        for (int i = 0; i < this.backingBuffers.length; ++i) {
            this.backingBuffers[i].dirtyAll();
        }
    }

    public class Allocation {
        private final Buffer.Allocation[] backingAllocations;

        public Allocation() {
            this.backingAllocations = new Buffer.Allocation[MultiBuffer.this.backingBuffers.length];
        }

        public Buffer.Allocation activeAllocation() {
            return this.backingAllocations[MultiBuffer.this.activeFrame];
        }

        public Buffer.Allocation allocation(int frame) {
            return this.backingAllocations[frame % this.backingAllocations.length];
        }

        public void free() {
            MultiBuffer.this.free(this);
        }

        public MultiBuffer<T> allocator() {
            return MultiBuffer.this;
        }
    }
}

