/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ECNetworking {
    public static final ChannelHandler CHANNEL = ChannelHandler.builder((String)"everycomp").register(NetworkDir.PLAY_TO_CLIENT, S2CBlockStateCheckMessage.class, S2CBlockStateCheckMessage::new).register(NetworkDir.BOTH, S2CModVersionCheckMessage.class, S2CModVersionCheckMessage::new).version(2).build();
    private static int lastInd = 0;

    public static void init() {
    }

    public static void sendPacket(ServerPlayer s) {
        if (ECConfigs.DEBUG_PACKET.get().booleanValue() || PlatHelper.isDev()) {
            lastInd = 0;
            EveryCompat.LOGGER.warn("Starting Blockstate Map validity check:");
            while (lastInd < Block.f_49791_.m_13562_()) {
                CHANNEL.sendToClientPlayer(s, (Message)new S2CBlockStateCheckMessage());
            }
        }
    }

    public static class S2CBlockStateCheckMessage
    implements Message {
        public S2CBlockStateCheckMessage(FriendlyByteBuf buf) {
            int start = buf.m_130242_();
            int size = buf.m_130242_();
            boolean mismatched = false;
            for (int i = start; i < start + size; ++i) {
                try {
                    BlockState exp;
                    BlockState b;
                    CompoundTag nbt = buf.m_130260_();
                    if (nbt == null) {
                        boolean bl = true;
                    }
                    if ((b = Utils.readBlockState((CompoundTag)nbt, null)) != (exp = (BlockState)Block.f_49791_.m_7942_(i))) {
                        if (!mismatched) {
                            EveryCompat.LOGGER.error("Found blockstate id mismatch from " + String.valueOf(b) + "at id " + i + ". Was expecting: " + String.valueOf(exp));
                        }
                        mismatched = true;
                        continue;
                    }
                    if (mismatched) {
                        EveryCompat.LOGGER.error("to" + String.valueOf(b) + "at id " + i);
                    }
                    mismatched = false;
                    continue;
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read blockstate in id map: ", (Throwable)e);
                    break;
                }
            }
            buf.release();
        }

        public S2CBlockStateCheckMessage() {
        }

        public void writeToBuffer(FriendlyByteBuf buf) {
            FriendlyByteBuf dummy = new FriendlyByteBuf(Unpooled.buffer());
            int start = lastInd;
            int i = lastInd;
            while (i < Block.f_49791_.m_13562_()) {
                ++lastInd;
                CompoundTag nbt = NbtUtils.m_129202_((BlockState)Block.m_49803_((int)i));
                dummy.m_130079_(nbt);
                if ((double)dummy.writerIndex() > 943718.4) break;
                ++i;
            }
            buf.m_130130_(start);
            buf.m_130130_(lastInd - start);
            buf.writeBytes((ByteBuf)dummy);
            dummy.release();
        }

        public void handle(ChannelHandler.Context context) {
        }
    }

    public static class S2CModVersionCheckMessage
    implements Message {
        private final Map<String, String> mods = new HashMap<String, String>();

        public S2CModVersionCheckMessage() {
            for (String m : EveryCompat.getDependencies()) {
                String v = PlatHelper.getModVersion((String)m);
                if (v == null) continue;
                this.mods.put(m, v);
            }
        }

        public S2CModVersionCheckMessage(FriendlyByteBuf buf) {
            this.mods.putAll(buf.m_236847_(buf1 -> buf.m_130277_(), buf1 -> buf.m_130277_()));
        }

        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.m_236831_(this.mods, (buf1, s) -> buf.m_130070_(s), (buf1, s) -> buf.m_130070_(s));
        }

        public void handle(ChannelHandler.Context context) {
            for (Map.Entry<String, String> m : this.mods.entrySet()) {
                String clientVersion = PlatHelper.getModVersion((String)m.getKey());
                String serverVersion = m.getValue();
                if (Objects.equals(serverVersion, clientVersion)) continue;
                context.disconnect((Component)Component.m_237113_((String)("EveryCompat has detected that server has mismatched mod versions for mod " + m.getKey() + ": requested version " + serverVersion + ", actual version " + clientVersion)));
            }
        }
    }
}

