/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class PageFlipButton
extends Button {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    public static final int width = 23;
    public static final int height = 13;
    private final Direction direction;
    private final Pageable pageable;

    PageFlipButton(int x, int y, Direction direction, Pageable pageable) {
        super(x, y, 23, 13, CommonComponents.f_237098_, button -> pageable.switchToPage(pageable.getCurrentPageNumber() + direction.distance), f_252438_);
        this.direction = direction;
        this.pageable = pageable;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        int textureX = 0;
        if (this.m_274382_()) {
            textureX += 23;
        }
        int textureY = 192;
        if (this.direction == Direction.BACKWARD) {
            textureY += 13;
        }
        graphics.m_280218_(texture, this.m_252754_(), this.m_252907_(), textureX, textureY, 23, 13);
    }

    public void updateState() {
        this.f_93624_ = this.pageable.isWithinRange(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    public void m_7435_(SoundManager soundManager) {
        soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
    }

    static interface Pageable {
        public void switchToPage(int var1);

        public int getCurrentPageNumber();

        public boolean isWithinRange(int var1);
    }

    static enum Direction {
        FORWARD(1),
        BACKWARD(-1);

        final int distance;

        private Direction(int distance) {
            this.distance = distance;
        }
    }
}

