/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class BakedQuadHelper {
    public static final VertexFormat FORMAT = DefaultVertexFormat.f_85811_;
    public static final int VERTEX_STRIDE = FORMAT.m_86017_();
    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 1;
    public static final int Z_OFFSET = 2;
    public static final int COLOR_OFFSET = 3;
    public static final int U_OFFSET = 4;
    public static final int V_OFFSET = 5;
    public static final int LIGHT_OFFSET = 6;
    public static final int NORMAL_OFFSET = 7;

    private BakedQuadHelper() {
    }

    public static BakedQuad clone(BakedQuad quad) {
        return new BakedQuad(Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length), quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static BakedQuad cloneWithCustomGeometry(BakedQuad quad, int[] vertexData) {
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static Vec3 getXYZ(int[] vertexData, int vertex) {
        float x = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 0]);
        float y = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 1]);
        float z = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 2]);
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static void setXYZ(int[] vertexData, int vertex, Vec3 xyz) {
        vertexData[vertex * BakedQuadHelper.VERTEX_STRIDE + 0] = Float.floatToRawIntBits((float)xyz.f_82479_);
        vertexData[vertex * BakedQuadHelper.VERTEX_STRIDE + 1] = Float.floatToRawIntBits((float)xyz.f_82480_);
        vertexData[vertex * BakedQuadHelper.VERTEX_STRIDE + 2] = Float.floatToRawIntBits((float)xyz.f_82481_);
    }

    public static Vec3 getNormalXYZ(int[] vertexData, int vertex) {
        int data = vertexData[vertex * VERTEX_STRIDE + 7];
        float x = (float)((byte)(data >> 24 & 0xFF)) / 127.0f;
        float y = (float)((byte)(data >> 16 & 0xFF)) / 127.0f;
        float z = (float)((byte)(data >> 8 & 0xFF)) / 127.0f;
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static void setNormalXYZ(int[] vertexData, int vertex, Vec3 xyz) {
        int data;
        int x = Byte.toUnsignedInt((byte)(Mth.m_14008_((double)xyz.f_82479_, (double)-1.0, (double)1.0) * 127.0));
        int y = Byte.toUnsignedInt((byte)(Mth.m_14008_((double)xyz.f_82480_, (double)-1.0, (double)1.0) * 127.0));
        int z = Byte.toUnsignedInt((byte)(Mth.m_14008_((double)xyz.f_82481_, (double)-1.0, (double)1.0) * 127.0));
        vertexData[vertex * BakedQuadHelper.VERTEX_STRIDE + 7] = data = x << 24 | y << 16 | z << 8;
    }

    public static float getU(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 4]);
    }

    public static float getV(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 5]);
    }

    public static void setU(int[] vertexData, int vertex, float u) {
        vertexData[vertex * BakedQuadHelper.VERTEX_STRIDE + 4] = Float.floatToRawIntBits(u);
    }

    public static void setV(int[] vertexData, int vertex, float v) {
        vertexData[vertex * BakedQuadHelper.VERTEX_STRIDE + 5] = Float.floatToRawIntBits(v);
    }
}

