/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridBehavior;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.item.PatternItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class CraftingGridBehavior
implements ICraftingGridBehavior {
    @Override
    public void onCrafted(INetworkAwareGrid grid, CraftingRecipe recipe, Player player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        NonNullList remainder = recipe.m_7457_((Container)grid.getCraftingMatrix());
        INetwork network = grid.getNetwork();
        CraftingContainer matrix = grid.getCraftingMatrix();
        for (int i = 0; i < grid.getCraftingMatrix().m_6643_(); ++i) {
            ItemStack slot = matrix.m_8020_(i);
            if (i < remainder.size() && !((ItemStack)remainder.get(i)).m_41619_()) {
                if (!slot.m_41619_() && slot.m_41613_() > 1) {
                    if (!player.m_150109_().m_36054_(((ItemStack)remainder.get(i)).m_41777_())) {
                        ItemStack remainderStack;
                        ItemStack itemStack = remainderStack = network == null ? ((ItemStack)remainder.get(i)).m_41777_() : network.insertItem(((ItemStack)remainder.get(i)).m_41777_(), ((ItemStack)remainder.get(i)).m_41613_(), Action.PERFORM);
                        if (!remainderStack.m_41619_()) {
                            Containers.m_18992_((Level)player.m_20193_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)remainderStack);
                        }
                    }
                    matrix.m_7407_(i, 1);
                    continue;
                }
                matrix.m_6836_(i, ((ItemStack)remainder.get(i)).m_41777_());
                continue;
            }
            if (slot.m_41619_()) continue;
            if (slot.m_41613_() == 1 && network != null && grid.isGridActive()) {
                ItemStack refill;
                if (availableItems == null) {
                    refill = network.extractItem(slot, 1, Action.PERFORM);
                } else if (availableItems.get(slot) != null) {
                    refill = availableItems.remove(slot, 1).getStack().m_41777_();
                    refill.m_41764_(1);
                    usedItems.add(refill);
                } else {
                    refill = ItemStack.f_41583_;
                }
                matrix.m_6836_(i, refill);
                if (refill.m_41619_()) continue;
                network.getItemStorageTracker().changed(player, refill.m_41777_());
                continue;
            }
            matrix.m_7407_(i, 1);
        }
        grid.onCraftingMatrixChanged();
    }

    @Override
    public void onCraftedShift(INetworkAwareGrid grid, Player player) {
        CraftingContainer matrix = grid.getCraftingMatrix();
        INetwork network = grid.getNetwork();
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        ItemStack crafted = grid.getCraftingResult().m_8020_(0);
        int maxCrafted = crafted.m_41741_();
        int amountCrafted = 0;
        boolean useNetwork = network != null && grid.isGridActive();
        IStackList<ItemStack> availableItems = API.instance().createItemStackList();
        if (useNetwork) {
            this.filterDuplicateStacks(network, matrix, availableItems);
        }
        IStackList<ItemStack> usedItems = API.instance().createItemStackList();
        ForgeHooks.setCraftingPlayer((Player)player);
        do {
            grid.onCrafted(player, availableItems, usedItems);
            craftedItemsList.add(crafted.m_41777_());
        } while (API.instance().getComparer().isEqual(crafted, grid.getCraftingResult().m_8020_(0)) && (amountCrafted += crafted.m_41613_()) < maxCrafted && amountCrafted + crafted.m_41613_() <= maxCrafted);
        if (useNetwork) {
            usedItems.getStacks().forEach(stack -> network.extractItem((ItemStack)stack.getStack(), ((ItemStack)stack.getStack()).m_41613_(), Action.PERFORM));
        }
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), (ItemStack)craftedItem.m_41777_(), (boolean)false);
            if (!remainder.m_41619_() && useNetwork) {
                remainder = network.insertItem(remainder, remainder.m_41613_(), Action.PERFORM);
            }
            if (remainder.m_41619_()) continue;
            Containers.m_18992_((Level)player.m_20193_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)remainder);
        }
        crafted.m_41678_(player.m_9236_(), player, amountCrafted);
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)amountCrafted), (Container)grid.getCraftingMatrix());
        ForgeHooks.setCraftingPlayer(null);
    }

    private void filterDuplicateStacks(INetwork network, CraftingContainer matrix, IStackList<ItemStack> availableItems) {
        for (int i = 0; i < matrix.m_6643_(); ++i) {
            ItemStack stack = network.getItemStorageCache().getList().get(matrix.m_8020_(i));
            if (stack == null || availableItems.get(stack) != null) continue;
            availableItems.add(stack);
        }
    }

    @Override
    public void onRecipeTransfer(INetworkAwareGrid grid, Player player, ItemStack[][] recipe) {
        INetwork network = grid.getNetwork();
        if (network != null && grid.getGridType() == GridType.CRAFTING && !network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        for (int i = 0; i < grid.getCraftingMatrix().m_6643_(); ++i) {
            ItemStack slot = grid.getCraftingMatrix().m_8020_(i);
            if (slot.m_41619_()) continue;
            if (grid.getGridType() == GridType.CRAFTING) {
                if (network != null && grid.isGridActive()) {
                    if (!network.insertItem(slot, slot.m_41613_(), Action.SIMULATE).m_41619_()) {
                        return;
                    }
                    network.insertItem(slot, slot.m_41613_(), Action.PERFORM);
                    network.getItemStorageTracker().changed(player, slot.m_41777_());
                } else if (!player.m_150109_().m_36054_(slot.m_41777_())) {
                    return;
                }
            }
            grid.getCraftingMatrix().m_6836_(i, ItemStack.f_41583_);
        }
        AtomicReference<Map<Item, ItemStack>> playerItems = new AtomicReference<Map<Item, ItemStack>>();
        block1: for (int i = 0; i < grid.getCraftingMatrix().m_6643_(); ++i) {
            if (recipe[i] == null) continue;
            ItemStack[] possibilities = recipe[i];
            if (network != null && grid.isGridActive() && network.getItemStorageCache() != null) {
                Arrays.sort(possibilities, this.compareByItemStackCounts(player, network, playerItems));
            }
            if (grid.getGridType() == GridType.CRAFTING) {
                boolean found = false;
                if (network != null && grid.isGridActive()) {
                    for (ItemStack possibility : possibilities) {
                        ItemStack took = network.extractItem(possibility, possibility.m_41613_(), 1, Action.PERFORM);
                        if (took.m_41619_()) continue;
                        grid.getCraftingMatrix().m_6836_(i, took);
                        network.getItemStorageTracker().changed(player, took.m_41777_());
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                for (ItemStack possibility : possibilities) {
                    for (int j = 0; j < player.m_150109_().m_6643_(); ++j) {
                        if (!API.instance().getComparer().isEqual(possibility, player.m_150109_().m_8020_(j), 1)) continue;
                        grid.getCraftingMatrix().m_6836_(i, ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_150109_().m_8020_(j), (int)1));
                        player.m_150109_().m_7407_(j, 1);
                        found = true;
                        break;
                    }
                    if (found) continue block1;
                }
                continue;
            }
            if (grid.getGridType() != GridType.PATTERN) continue;
            grid.getCraftingMatrix().m_6836_(i, possibilities.length == 0 ? ItemStack.f_41583_ : possibilities[0]);
        }
        if (grid.getGridType() == GridType.PATTERN) {
            ((GridNetworkNode)grid).setProcessingPattern(false);
            ((GridNetworkNode)grid).markDirty();
        }
    }

    private Comparator<ItemStack> compareByItemStackCounts(Player player, INetwork network, AtomicReference<Map<Item, ItemStack>> playerItems) {
        return Comparator.comparingInt(itemStack -> {
            ItemStack onPlayer;
            ItemStack stack = network.getItemStorageCache().getList().get((ItemStack)itemStack);
            if (stack != null) {
                return stack.m_41613_();
            }
            if (network.getCraftingManager().getPattern((ItemStack)itemStack) != null) {
                return 1;
            }
            if (playerItems.get() == null) {
                playerItems.set(this.makePlayerInventoryMap(player, network));
            }
            if ((onPlayer = (ItemStack)((Map)playerItems.get()).get(itemStack.m_41720_())) != null) {
                return onPlayer.m_41613_();
            }
            return 0;
        }).reversed();
    }

    private Map<Item, ItemStack> makePlayerInventoryMap(Player player, INetwork network) {
        HashMap<Item, ItemStack> playerItems = new HashMap<Item, ItemStack>();
        for (int j = 0; j < player.m_150109_().m_6643_(); ++j) {
            ItemStack inventoryStack = player.m_150109_().m_8020_(j);
            if (inventoryStack.m_41720_() instanceof ICraftingPatternProvider) {
                ICraftingPattern pattern = PatternItem.fromCache(network.getLevel(), inventoryStack);
                if (!pattern.isValid()) continue;
                for (ItemStack stack : pattern.getOutputs()) {
                    if (stack.m_41619_()) continue;
                    playerItems.put(stack.m_41720_(), stack);
                }
                continue;
            }
            playerItems.put(inventoryStack.m_41720_(), inventoryStack);
        }
        return playerItems;
    }
}

