/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.mightymail.block.MailboxBlock;
import com.mrcrayfish.mightymail.core.ModBlocks;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MigrateCommand {
    private static final WeakHashMap<UUID, Long> PENDING = new WeakHashMap();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mighty_mail:migrate").requires(source -> source.m_6761_(2) && source.m_230897_())).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player != null) {
                PENDING.put(player.m_20148_(), Util.m_137550_());
                MutableComponent link = Component.m_237113_((String)"CONFIRM");
                link.m_6270_(link.m_7383_().m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mighty_mail:confirm")));
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"This is an irreversible action. Click ").m_7220_((Component)link).m_130946_(" to start action."), false);
                return 1;
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mighty_mail:confirm").requires(source -> source.m_6761_(2) && source.m_230897_())).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player != null && PENDING.containsKey(player.m_20148_())) {
                if (Util.m_137550_() - PENDING.get(player.m_20148_()) >= 10000L) {
                    PENDING.remove(player.m_20148_());
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Action expired. You must confirm within 10 seconds."));
                    return 0;
                }
                PENDING.remove(player.m_20148_());
                MigrateCommand.migrateMailboxes((CommandSourceStack)context.getSource());
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid confirmation. You must run /mighty_mail:migrate first"));
            return 0;
        }));
    }

    private static int migrateMailboxes(CommandSourceStack source) {
        MinecraftServer server = source.m_81377_();
        DeliveryService refurbishedService = DeliveryService.get((MinecraftServer)server).orElse(null);
        if (refurbishedService == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to get mailbox registry from the furniture mod. This should not happen..."));
            return 0;
        }
        com.mrcrayfish.mightymail.mail.DeliveryService service = com.mrcrayfish.mightymail.mail.DeliveryService.get(server).orElse(null);
        if (service == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to get mailbox registry from mighty mail. This should not happen..."));
            return 0;
        }
        AtomicInteger counter = new AtomicInteger(0);
        service.getMailboxes().forEach((uuid, mailbox) -> {
            Block newBlock;
            ServerLevel level = server.m_129880_(mailbox.levelKey());
            if (level == null) {
                return;
            }
            BlockEntity entity = level.m_7702_(mailbox.pos());
            if (!(entity instanceof com.mrcrayfish.mightymail.blockentity.MailboxBlockEntity)) {
                return;
            }
            BlockState state = level.m_8055_(mailbox.pos());
            if (!(state.m_60734_() instanceof MailboxBlock)) {
                return;
            }
            Direction direction = (Direction)state.m_61143_((Property)MailboxBlock.DIRECTION);
            boolean enabled = (Boolean)state.m_61143_((Property)MailboxBlock.ENABLED);
            if (state.m_60734_() == ModBlocks.MAIL_BOX_OAK.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_OAK.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_SPRUCE.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_SPRUCE.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_BIRCH.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_BIRCH.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_JUNGLE.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_JUNGLE.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_ACACIA.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_ACACIA.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_DARK_OAK.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_DARK_OAK.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_MANGROVE.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_MANGROVE.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_CRIMSON.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_CRIMSON.get();
            } else if (state.m_60734_() == ModBlocks.MAIL_BOX_WARPED.get()) {
                newBlock = (Block)com.mrcrayfish.furniture.refurbished.core.ModBlocks.MAIL_BOX_WARPED.get();
            } else {
                return;
            }
            BlockState state1 = (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction)).m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.valueOf(enabled));
            level.m_7731_(mailbox.pos(), state1, 3);
            MailboxBlockEntity newBlockEntity = new MailboxBlockEntity(mailbox.pos(), state1);
            level.m_151523_((BlockEntity)newBlockEntity);
            newBlockEntity.regenerateId();
            Mailbox newMailbox = newBlockEntity.getMailbox();
            newMailbox.customName().setValue((Object)((String)mailbox.customName().getValue()));
            newMailbox.setOwner((UUID)mailbox.owner().getValue());
            counter.incrementAndGet();
        });
        source.m_288197_(() -> Component.m_237113_((String)"Successfully migrated %s mailboxes".formatted(counter.get())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }
}

