/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.mightymail.block.RotatedBlock;
import com.mrcrayfish.mightymail.blockentity.MailboxBlockEntity;
import com.mrcrayfish.mightymail.client.ScreenHooks;
import com.mrcrayfish.mightymail.mail.DeliveryService;
import com.mrcrayfish.mightymail.mail.Mailbox;
import com.mrcrayfish.mightymail.util.Utils;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends RotatedBlock
implements EntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private final Map<BlockState, VoxelShape> shapes;

    public MailboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.generateShapes();
    }

    protected Map<BlockState, VoxelShape> generateShapes() {
        ImmutableList states = this.m_49965_().m_61056_();
        VoxelShape standShape = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)11.0, (double)9.5);
        VoxelShape boxShape = Block.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
        VoxelShape joinedShape = Shapes.m_83148_((VoxelShape)standShape, (VoxelShape)boxShape, (BooleanOp)BooleanOp.f_82695_).m_83296_();
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> joinedShape)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.shapes.get(state);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof MailboxBlockEntity) {
                    MailboxBlockEntity mailbox = (MailboxBlockEntity)blockEntity;
                    mailbox.getMailbox().owner().setValue((Object)player.m_20148_());
                    DeliveryService.get(((ServerLevel)level).m_7654_()).ifPresent(service -> service.markMailboxAsPendingName(player, level, pos));
                }
            } else {
                ScreenHooks.openMailboxNameScreen(pos);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && !state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity mailbox = (MailboxBlockEntity)blockEntity;
            Optional.ofNullable(mailbox.getMailbox()).ifPresent(Mailbox::remove);
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)mailbox);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof MailboxBlockEntity) {
            Mailbox mailbox;
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            if (!DeliveryService.isDeliverableDimension(level)) {
                ((ServerPlayer)player).m_240418_((Component)Utils.translation("gui", "invalid_mailbox", new Object[0]), true);
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 3);
            }
            if ((mailbox = blockEntity2.getMailbox()) != null && !mailbox.hasOwner()) {
                mailbox.setOwner(player.m_20148_());
            }
            player.m_5893_((MenuProvider)blockEntity2);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENABLED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MailboxBlockEntity(pos, state);
    }
}

