/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.forge.common;

import earth.terrarium.adastra.client.forge.ClientPlatformUtilsImpl;
import earth.terrarium.adastra.client.models.armor.SpaceSuitModel;
import earth.terrarium.adastra.common.items.armor.JetSuitItem;
import earth.terrarium.adastra.common.items.armor.base.CustomDyeableArmorItem;
import earth.terrarium.adastra.common.tags.ModItemTags;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={CustomDyeableArmorItem.class})
public abstract class CustomDyeableArmorItemMixin
extends Item {
    public CustomDyeableArmorItemMixin(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ClientPlatformUtilsImpl.ArmorRenderer renderer;

            private static <T extends LivingEntity> void uncheckedCopyTo(HumanoidModel<T> from, HumanoidModel<?> to) {
                from.m_102872_(to);
            }

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = ClientPlatformUtilsImpl.ARMOR_RENDERERS.get(stack.m_41720_());
                }
                if (this.renderer == null) {
                    return original;
                }
                ModelPart root = Minecraft.m_91087_().m_167973_().m_171103_(this.renderer.layer());
                HumanoidModel<?> model = this.renderer.factory().create(root, slot, stack, original);
                Item item = stack.m_41720_();
                if (item instanceof JetSuitItem) {
                    JetSuitItem suit = (JetSuitItem)item;
                    suit.spawnParticles(entity.m_9236_(), entity, original, stack);
                }
                return model;
            }

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                HumanoidModel<?> replacement = this.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
                if (replacement != original) {
                    1.uncheckedCopyTo(original, replacement);
                    return replacement;
                }
                return original;
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (stack.m_204117_(ModItemTags.JET_SUITS)) {
            return SpaceSuitModel.JET_SUIT_TEXTURE.toString();
        }
        if (stack.m_204117_(ModItemTags.NETHERITE_SPACE_SUITS)) {
            return SpaceSuitModel.NETHERITE_SPACE_SUIT_TEXTURE.toString();
        }
        if (stack.m_204117_(ModItemTags.SPACE_SUITS)) {
            return SpaceSuitModel.SPACE_SUIT_TEXTURE.toString();
        }
        return null;
    }
}

