/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;

public class ItemUtils {
    public static void push(Container from, Container to, int[] fromSlots, Direction direction) {
        if (ItemUtils.inventoryFull(to)) {
            return;
        }
        for (int slot : fromSlots) {
            ItemStack stack = from.m_8020_(slot);
            if (stack.m_41619_() || !ItemUtils.addItem(to, stack.m_255036_(1), IntStream.range(0, to.m_6643_()).toArray(), direction)) continue;
            from.m_7407_(slot, 1);
            from.m_6596_();
            return;
        }
    }

    public static void pull(Container from, Container to, int[] toSlots, Direction direction) {
        if (ItemUtils.inventoryFull(to)) {
            return;
        }
        for (int i = 0; i < from.m_6643_(); ++i) {
            ItemStack stack = from.m_8020_(i);
            if (stack.m_41619_() || !ItemUtils.addItem(to, stack.m_255036_(1), toSlots, direction)) continue;
            from.m_7407_(i, 1);
            to.m_6596_();
            return;
        }
    }

    public static boolean inventoryFull(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) {
                return false;
            }
            if (stack.m_41613_() >= stack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private static boolean addItem(Container to, ItemStack stack, int[] toSlots, Direction direction) {
        for (int slot : toSlots) {
            WorldlyContainer worldlyContainer;
            int[] slots;
            if (to instanceof WorldlyContainer && IntStream.of(slots = (worldlyContainer = (WorldlyContainer)to).m_7071_(direction)).noneMatch(i -> i == slot)) continue;
            ItemStack toStack = to.m_8020_(slot);
            if (toStack.m_41619_()) {
                to.m_6836_(slot, stack);
                return true;
            }
            if (!ItemUtils.canAddItem(toStack, stack)) continue;
            toStack.m_41769_(1);
            return true;
        }
        return false;
    }

    public static void addItem(Container container, ItemStack output, int ... slots) {
        for (int slot : slots) {
            ItemStack input = container.m_8020_(slot);
            if (input.m_41619_()) {
                container.m_6836_(slot, output.m_41777_());
                return;
            }
            if (!ItemUtils.canAddItem(input, output)) continue;
            input.m_41769_(output.m_41613_());
            return;
        }
    }

    public static boolean canAddItem(ItemStack input, ItemStack output) {
        return input.m_41619_() || ItemStack.m_150942_((ItemStack)input, (ItemStack)output) && output.m_41613_() + input.m_41613_() <= input.m_41741_();
    }

    public static boolean canAddItem(Container container, ItemStack output, int ... slots) {
        for (int slot : slots) {
            ItemStack input = container.m_8020_(slot);
            if (!ItemUtils.canAddItem(input, output)) continue;
            return true;
        }
        return false;
    }
}

