/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.pipes;

import earth.terrarium.adastra.common.blockentities.pipes.PipeBlockEntity;
import earth.terrarium.adastra.common.blocks.pipes.PipeBlock;
import earth.terrarium.adastra.common.blocks.pipes.TransferablePipe;
import earth.terrarium.adastra.common.blocks.properties.PipeProperty;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public interface Pipe {
    default public void findNodes(ServerLevel level, BlockPos startPos) {
        LongOpenHashSet visitedNodes = new LongOpenHashSet();
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        queue.enqueue(startPos.m_121878_());
        while (!queue.isEmpty()) {
            long currentPosLong = queue.dequeueLong();
            BlockPos pipePos = BlockPos.m_122022_((long)currentPosLong);
            BlockEntity blockEntity = level.m_7702_(pipePos);
            if (!(blockEntity instanceof PipeBlockEntity)) continue;
            PipeBlockEntity pipeEntity = (PipeBlockEntity)blockEntity;
            BlockState pipeState = pipeEntity.m_58900_();
            Direction[] directions = pipeEntity.connectedDirections();
            if (directions == null) continue;
            for (Direction direction : directions) {
                BlockPos pos = pipePos.m_121945_(direction);
                long longPos = pos.m_121878_();
                if (!visitedNodes.add(longPos)) continue;
                if (level.m_8055_(pos).m_60734_() instanceof TransferablePipe) {
                    queue.enqueue(longPos);
                    continue;
                }
                BlockEntity entity = level.m_7702_(pos);
                if (entity == null || !this.isValid(entity, direction)) continue;
                this.addNode(entity, (PipeProperty)((Object)pipeState.m_61143_((Property)PipeBlock.DIRECTION_TO_CONNECTION.get(direction))), direction, pos);
            }
        }
    }

    public void addNode(@NotNull BlockEntity var1, PipeProperty var2, Direction var3, BlockPos var4);

    default public void transfer(ServerLevel level, long transferRate, Map<BlockPos, Direction> sources, Map<BlockPos, Direction> consumers) {
        for (Map.Entry<BlockPos, Direction> sourceEntry : sources.entrySet()) {
            BlockEntity sourceEntity = level.m_7702_(sourceEntry.getKey());
            if (sourceEntity == null || !this.isValid(sourceEntity, sourceEntry.getValue())) {
                return;
            }
            long rate = transferRate / (long)consumers.size();
            for (Map.Entry<BlockPos, Direction> consumerEntry : consumers.entrySet()) {
                BlockPos pos = consumerEntry.getKey();
                Direction direction = consumerEntry.getValue();
                BlockEntity consumerEntity = level.m_7702_(pos);
                if (consumerEntity == null || !this.isValid(consumerEntity, direction)) continue;
                this.moveContents(rate, sourceEntity, consumerEntity, direction);
            }
        }
    }

    public void moveContents(long var1, @NotNull BlockEntity var3, @NotNull BlockEntity var4, Direction var5);

    public boolean isValid(@NotNull BlockEntity var1, Direction var2);
}

