/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.RecipeMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.CompressorMenu;
import earth.terrarium.adastra.common.recipes.machines.CompressingRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CompressorBlockEntity
extends RecipeMachineBlockEntity<CompressingRecipe> {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));

    public CompressorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 3, ModRecipeTypes.COMPRESSING);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new CompressorMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.ironTierEnergyCapacity, MachineConfig.ironTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby(this, pos, new int[]{2}, sideConfig.get(1), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(2), filter);
    }

    @Override
    public void recipeTick(ServerLevel level, WrappedBlockEnergyContainer energyStorage) {
        if (this.recipe == null) {
            return;
        }
        if (!this.canCraft()) {
            this.clearRecipe();
            return;
        }
        energyStorage.internalExtract((long)((CompressingRecipe)this.recipe).energy(), false);
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            return;
        }
        this.craft();
    }

    @Override
    public void craft() {
        if (this.recipe == null) {
            return;
        }
        this.m_8020_(1).m_41774_(1);
        ItemUtils.addItem((Container)this, ((CompressingRecipe)this.recipe).result(), 2);
        this.cookTime = 0;
        if (this.m_8020_(1).m_41619_()) {
            this.clearRecipe();
        }
    }

    @Override
    public void update() {
        if (this.level().m_5776_()) {
            return;
        }
        this.quickCheck.m_213657_((Container)this, this.level()).ifPresent(r -> {
            this.recipe = r;
            this.cookTimeTotal = r.cookingTime();
        });
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[]{1, 2};
    }
}

