/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.base;

import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class EnergyContainerMachineBlockEntity
extends ContainerMachineBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    protected WrappedBlockEnergyContainer energyContainer;

    public EnergyContainerMachineBlockEntity(BlockPos pos, BlockState state, int containerSize) {
        super(pos, state, containerSize);
    }

    public ChargeSlotType getChargeSlotType() {
        return ChargeSlotType.POWER_MACHINE;
    }

    @Override
    public void internalServerTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.internalServerTick(level, time, state, pos);
        switch (this.getChargeSlotType()) {
            case POWER_ITEM: {
                this.insertBatterySlot();
                break;
            }
            case POWER_MACHINE: {
                this.extractBatterySlot();
            }
        }
    }

    public void extractBatterySlot() {
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        if (!EnergyContainer.holdsEnergy((ItemStack)stack)) {
            return;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        EnergyApi.moveEnergy((ItemStackHolder)holder, (BlockEntity)this, null, (long)this.energyContainer.maxInsert(), (boolean)false);
        if (holder.isDirty()) {
            this.m_6836_(0, holder.getStack());
        }
    }

    public void insertBatterySlot() {
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        if (!EnergyContainer.holdsEnergy((ItemStack)stack)) {
            return;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        EnergyApi.moveEnergy((BlockEntity)this, null, (ItemStackHolder)holder, (long)this.energyContainer.maxExtract(), (boolean)false);
        if (holder.isDirty()) {
            this.m_6836_(0, holder.getStack());
        }
    }

    public static enum ChargeSlotType {
        NONE,
        POWER_MACHINE,
        POWER_ITEM;

    }
}

