/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.entities.vehicles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.adastra.client.models.entities.vehicles.LanderModel;
import earth.terrarium.adastra.common.entities.vehicles.Lander;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class LanderRenderer
extends EntityRenderer<Lander> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ad_astra", "textures/entity/lander/lander.png");
    protected final EntityModel<Lander> model;

    public LanderRenderer(EntityRendererProvider.Context context, ModelLayerLocation layer) {
        super(context);
        this.f_114477_ = 0.5f;
        this.model = new LanderModel(context.m_174023_(layer));
    }

    public void render(Lander entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            pose.m_252880_(0.0f, 1.55f, 0.0f);
            pose.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
            float xRot = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
            pose.m_252781_(Axis.f_252403_.m_252977_(-xRot));
            pose.m_85841_(-1.0f, -1.0f, 1.0f);
            this.model.m_6973_((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            VertexConsumer consumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
            this.model.m_7695_((PoseStack)pose, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(Lander entity) {
        return TEXTURE;
    }
}

