/*
 * Decompiled with CFR 0.152.
 */
package com.deltajay.tonsofenchants.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class LootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"tonsofenchants");
    public static final RegistryObject<Codec<MidasTouchModifier>> MIDAS_GOLD_ITEM = LOOT_MODIFIER_SERIALIZERS.register("midas_touch_gold", MidasTouchModifier.CODEC);
    public static final RegistryObject<Codec<Smelting>> SMELTING = LOOT_MODIFIER_SERIALIZERS.register("smelting", Smelting.CODEC);

    protected static class MidasTouchModifier
    extends LootModifier {
        public static final Supplier<Codec<MidasTouchModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> MidasTouchModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).apply((Applicative)inst, MidasTouchModifier::new)));
        private final Item item;

        protected MidasTouchModifier(LootItemCondition[] conditionsIn, Item item) {
            super(conditionsIn);
            this.item = item;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (context.m_230907_().m_188501_() <= 0.025f) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    protected static class Smelting
    extends LootModifier {
        public static final Supplier<Codec<Smelting>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> Smelting.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, Smelting::new)));

        public Smelting(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @NotNull
        public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ObjectArrayList ret = new ObjectArrayList();
            generatedLoot.forEach(stack -> ret.add((Object)Smelting.smelt(stack, context)));
            return ret;
        }

        private static ItemStack smelt(ItemStack stack, LootContext context) {
            return context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(smeltingRecipe -> smeltingRecipe.m_8043_(context.m_78952_().m_9598_())).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse(stack);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

