/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.registries;

import mekanism.common.resource.IResource;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public enum EMBlockResourceInfo implements IResource
{
    BETTER_GOLD("better_gold", 5.0f, 9.0f, MapColor.f_283832_),
    PLASLITHERITE("plaslitherite", 25.0f, 2400.0f, MapColor.f_283811_, NoteBlockInstrument.BASEDRUM, -1, 0, false, false, PushReaction.NORMAL);

    private final String registrySuffix;
    private final MapColor mapColor;
    private final PushReaction pushReaction;
    private final boolean portalFrame;
    private final boolean burnsInFire;
    private final NoteBlockInstrument instrument;
    private final float resistance;
    private final float hardness;
    private final int burnTime;
    private final int lightValue;

    private EMBlockResourceInfo(String registrySuffix, float hardness, float resistance, MapColor mapColor) {
        this(registrySuffix, hardness, resistance, mapColor, null);
    }

    private EMBlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument) {
        this(registrySuffix, hardness, resistance, mapColor, instrument, -1);
    }

    private EMBlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument, int burnTime) {
        this(registrySuffix, hardness, resistance, mapColor, instrument, burnTime, 0);
    }

    private EMBlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument, int burnTime, int lightValue) {
        this(registrySuffix, hardness, resistance, mapColor, instrument, burnTime, lightValue, true, false, PushReaction.NORMAL);
    }

    private EMBlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument, int burnTime, int lightValue, boolean burnsInFire, boolean portalFrame, PushReaction pushReaction) {
        this.registrySuffix = registrySuffix;
        this.pushReaction = pushReaction;
        this.portalFrame = portalFrame;
        this.burnsInFire = burnsInFire;
        this.burnTime = burnTime;
        this.lightValue = lightValue;
        this.resistance = resistance;
        this.hardness = hardness;
        this.instrument = instrument;
        this.mapColor = mapColor;
    }

    public String getRegistrySuffix() {
        return this.registrySuffix;
    }

    public boolean isPortalFrame() {
        return this.portalFrame;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean burnsInFire() {
        return this.burnsInFire;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public BlockBehaviour.Properties modifyProperties(BlockBehaviour.Properties properties) {
        if (this.instrument != null) {
            properties.m_280658_(this.instrument);
        }
        return properties.m_284180_(this.mapColor).m_60913_(this.hardness, this.resistance).m_60953_(state -> this.lightValue).m_278166_(this.pushReaction);
    }
}

