/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.item.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemPipeType
extends PipeType<Item> {
    public static final ItemPipeType INSTANCE = new ItemPipeType();

    @Override
    public String getKey() {
        return "Item";
    }

    @Override
    public Capability<?> getCapability() {
        return ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public Filter<Item> createFilter() {
        return new ItemFilter();
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.NEAREST;
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.item";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ModBlocks.ITEM_PIPE.get());
    }

    @Override
    public Component getTransferText(@Nullable Upgrade upgrade) {
        return Component.m_237110_((String)"tooltip.pipez.rate.item", (Object[])new Object[]{this.getRate(upgrade), this.getSpeed(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        for (Direction side : Direction.values()) {
            IItemHandler itemHandler;
            PipeTileEntity.Connection extractingConnection;
            if (tileEntity.m_58904_().m_46467_() % (long)this.getSpeed(tileEntity, side) != 0L || !tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (extractingConnection = tileEntity.getExtractingConnection(side)) == null || (itemHandler = (IItemHandler)extractingConnection.getItemHandler(tileEntity.m_58904_()).orElse(null)) == null) continue;
            List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
            if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(tileEntity, side, connections, itemHandler);
                continue;
            }
            this.insertOrdered(tileEntity, side, connections, itemHandler);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IItemHandler itemHandler) {
        if (connections.isEmpty()) {
            return;
        }
        int itemsToTransfer = this.getRate(tileEntity, side);
        boolean[] inventoriesFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (itemsToTransfer > 0 && this.hasNotInserted(inventoriesFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IItemHandler destination = (IItemHandler)connection.getItemHandler(tileEntity.m_58904_()).orElse(null);
            boolean hasInserted = false;
            if (destination != null && !inventoriesFull[p] && !this.isFull(destination)) {
                for (int j = 0; j < itemHandler.getSlots(); ++j) {
                    ItemStack simulatedExtract = itemHandler.extractItem(j, 1, true);
                    if (simulatedExtract.m_41619_() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                    ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)simulatedExtract, (boolean)false);
                    int insertedAmount = simulatedExtract.m_41613_() - stack.m_41613_();
                    if (insertedAmount <= 0) continue;
                    itemsToTransfer -= insertedAmount;
                    itemHandler.extractItem(j, insertedAmount, false);
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                inventoriesFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IItemHandler itemHandler) {
        int itemsToTransfer = this.getRate(tileEntity, side);
        ArrayList<ItemStack> nonFittingItems = new ArrayList<ItemStack>();
        block0: for (PipeTileEntity.Connection connection : connections) {
            nonFittingItems.clear();
            IItemHandler destination = (IItemHandler)connection.getItemHandler(tileEntity.m_58904_()).orElse(null);
            if (destination == null || this.isFull(destination)) continue;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemsToTransfer <= 0) break block0;
                ItemStack simulatedExtract = itemHandler.extractItem(i, itemsToTransfer, true);
                if (simulatedExtract.m_41619_() || nonFittingItems.stream().anyMatch(stack -> ItemUtils.isStackable(stack, simulatedExtract)) || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                ItemStack stack2 = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)simulatedExtract, (boolean)false);
                int insertedAmount = simulatedExtract.m_41613_() - stack2.m_41613_();
                if (insertedAmount <= 0) {
                    nonFittingItems.add(simulatedExtract);
                }
                itemsToTransfer -= insertedAmount;
                itemHandler.extractItem(i, insertedAmount, false);
            }
        }
    }

    private boolean isFull(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41613_() >= itemHandler.getSlotLimit(i)) continue;
            return false;
        }
        return true;
    }

    private boolean canInsert(PipeTileEntity.Connection connection, ItemStack stack, List<Filter<?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter2, stack)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(filter3, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Item> filter, ItemStack stack) {
        CompoundTag metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || filter.getTag().contains(stack.m_41720_());
        }
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((Tag)metadata, (Tag)stack.m_41783_())) {
                return filter.getTag() == null || filter.getTag().contains(stack.m_41720_());
            }
            return false;
        }
        CompoundTag stackNBT = stack.m_41783_();
        if (stackNBT == null) {
            return metadata.m_128440_() <= 0;
        }
        if (!this.deepFuzzyCompare((Tag)metadata, (Tag)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || filter.getTag().contains(stack.m_41720_());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    public int getSpeed(PipeLogicTileEntity tileEntity, Direction direction) {
        return this.getSpeed(tileEntity.getUpgrade(direction));
    }

    public int getSpeed(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.itemPipeSpeed.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedUltimate.get();
            }
        }
        return 1;
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.itemPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

