/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.events;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import uk.co.dotcode.customvillagertrades.CVT;
import uk.co.dotcode.customvillagertrades.ConfigHandler;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.events.TradeRegistry;
import uk.co.dotcode.customvillagertrades.trades.MyTrade;
import uk.co.dotcode.customvillagertrades.trades.MyTradeItem;
import uk.co.dotcode.customvillagertrades.trades.MyWandererTrade;
import uk.co.dotcode.customvillagertrades.trades.TradeCollection;
import uk.co.dotcode.customvillagertrades.trades.WandererTradeCollection;

public class CVTCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        int permissionLevel = CVT.globalConfig.opLevel;
        LiteralArgumentBuilder refreshCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadCVT").requires(commandSource -> commandSource.m_6761_(permissionLevel))).executes(CVTCommands::refreshTrades);
        LiteralArgumentBuilder exportCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"exportCVT").requires(commandSource -> commandSource.m_6761_(permissionLevel))).executes(CVTCommands::exportTrades);
        LiteralArgumentBuilder addCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addCVT").requires(commandSource -> commandSource.m_6761_(permissionLevel))).then(Commands.m_82129_((String)"profession", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CVTCommands::professionArgumentSuggestions).then(Commands.m_82129_((String)"offerItem", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).then(Commands.m_82129_((String)"offerAmount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).then(Commands.m_82129_((String)"requestItem", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).then(Commands.m_82129_((String)"requestAmount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).then(Commands.m_82129_((String)"tradeExp", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"maxUses", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"tradeLevel", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(CVTCommands::addTrade)))))))));
        LiteralArgumentBuilder removeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removeCVT").requires(commandSource -> commandSource.m_6761_(permissionLevel))).then(Commands.m_82129_((String)"UTID", (ArgumentType)StringArgumentType.greedyString()).suggests(CVTCommands::utidArgumentSuggestions).executes(CVTCommands::removeTrade));
        dispatcher.register(refreshCommand);
        dispatcher.register(exportCommand);
        dispatcher.register(addCommand);
        dispatcher.register(removeCommand);
    }

    static int refreshTrades(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CVT.reload();
        CVTCommands.broadcastMessage(commandContext, "Reloaded villager trades");
        for (Player p : ((CommandSourceStack)commandContext.getSource()).m_81377_().m_6846_().m_11314_()) {
            CVT.sendConfigIssues(p);
        }
        return 1;
    }

    static int exportTrades(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CVTCommands.exportAllTrades((Entity)((CommandSourceStack)commandContext.getSource()).m_230896_());
        CVTCommands.exportWandererTrades((Entity)((CommandSourceStack)commandContext.getSource()).m_230896_());
        CVTCommands.broadcastMessage(commandContext, "Exported villager trades to 'config/custom trades' folder");
        return 1;
    }

    static int addTrade(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MyTrade trade = new MyTrade();
        MyTradeItem offer = new MyTradeItem(TradeUtil.getRegistryNameItem(ItemArgument.m_120963_(commandContext, (String)"offerItem").m_120979_()).toString(), IntegerArgumentType.getInteger(commandContext, (String)"offerAmount"), 0);
        MyTradeItem request = new MyTradeItem(TradeUtil.getRegistryNameItem(ItemArgument.m_120963_(commandContext, (String)"requestItem").m_120979_()).toString(), IntegerArgumentType.getInteger(commandContext, (String)"requestAmount"), 0);
        trade.offer = offer;
        trade.request = request;
        trade.tradeExp = IntegerArgumentType.getInteger(commandContext, (String)"tradeExp");
        trade.maxUses = IntegerArgumentType.getInteger(commandContext, (String)"maxUses");
        trade.tradeLevel = IntegerArgumentType.getInteger(commandContext, (String)"tradeLevel");
        String UTID = TradeRegistry.addNewTrade(ResourceLocationArgument.m_107011_(commandContext, (String)"profession").toString(), trade);
        CVTCommands.broadcastMessage(commandContext, "Added new trade with UTID: " + UTID);
        return 1;
    }

    static int removeTrade(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String message = TradeRegistry.removeTrade(StringArgumentType.getString(commandContext, (String)"UTID"));
        CVTCommands.broadcastMessage(commandContext, message);
        return 1;
    }

    private static void exportAllTrades(Entity player) {
        for (VillagerProfession p : TradeUtil.getAllProfessions()) {
            Int2ObjectMap existingTrades = (Int2ObjectMap)VillagerTrades.f_35627_.get(p);
            if (existingTrades == null) continue;
            TradeCollection coll = new TradeCollection();
            coll.profession = TradeUtil.getKeyFromProfession(p);
            coll.removeOtherTrades = false;
            ArrayList<MyTrade> convertedTrades = new ArrayList<MyTrade>();
            for (int i = 1; i <= existingTrades.size(); ++i) {
                for (int j = 0; j < ((VillagerTrades.ItemListing[])existingTrades.get(i)).length; ++j) {
                    MerchantOffer original = null;
                    try {
                        original = ((VillagerTrades.ItemListing[])existingTrades.get(i))[j].m_213663_(player, TradeUtil.randomSource);
                    }
                    catch (NullPointerException e) {
                        ModLogger.warn("Could not export a trade entry for " + p.toString());
                        e.printStackTrace();
                        continue;
                    }
                    if (original == null) continue;
                    MyTrade convertedEntry = new MyTrade();
                    convertedEntry.offer = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45368_().m_41720_()).toString(), original.m_45368_().m_41613_(), 0);
                    if (original.m_45368_().m_41783_() != null) {
                        convertedEntry.offer.advancedNBTData = original.m_45368_().m_41783_().toString();
                    }
                    convertedEntry.request = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45352_().m_41720_()).toString(), original.m_45352_().m_41613_(), 0);
                    if (original.m_45352_().m_41783_() != null) {
                        convertedEntry.request.advancedNBTData = original.m_45352_().m_41783_().toString();
                    }
                    if (!original.m_45364_().m_41619_()) {
                        convertedEntry.additionalRequest = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45364_().m_41720_()).toString(), original.m_45364_().m_41613_(), 0);
                        if (original.m_45364_().m_41783_() != null) {
                            convertedEntry.additionalRequest.advancedNBTData = original.m_45364_().m_41783_().toString();
                        }
                    }
                    convertedEntry.tradeExp = original.m_45379_();
                    convertedEntry.maxUses = original.m_45373_();
                    convertedEntry.priceMultiplier = original.m_45378_();
                    convertedEntry.demand = original.m_45375_();
                    convertedEntry.tradeLevel = i;
                    convertedTrades.add(convertedEntry);
                }
            }
            coll.trades = convertedTrades.toArray(new MyTrade[convertedTrades.size()]);
            ConfigHandler.exportTradeCollection(coll);
        }
    }

    private static void exportWandererTrades(Entity player) {
        MyWandererTrade convertedEntry;
        MerchantOffer original;
        int j;
        Int2ObjectMap existingTrades = VillagerTrades.f_35628_;
        WandererTradeCollection coll = new WandererTradeCollection();
        coll.profession = "wanderer";
        coll.removeOtherTrades = false;
        ArrayList<MyWandererTrade> convertedTrades = new ArrayList<MyWandererTrade>();
        for (j = 0; j < ((VillagerTrades.ItemListing[])existingTrades.get(1)).length; ++j) {
            original = null;
            try {
                original = ((VillagerTrades.ItemListing[])existingTrades.get(1))[j].m_213663_(player, TradeUtil.randomSource);
            }
            catch (NullPointerException e) {
                ModLogger.warn("Could not export a trade entry for wanderer");
                e.printStackTrace();
                continue;
            }
            if (original == null) continue;
            convertedEntry = new MyWandererTrade();
            convertedEntry.offer = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45368_().m_41720_()).toString(), original.m_45368_().m_41613_(), 0);
            if (original.m_45368_().m_41783_() != null) {
                convertedEntry.offer.advancedNBTData = original.m_45368_().m_41783_().toString();
            }
            convertedEntry.request = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45352_().m_41720_()).toString(), original.m_45352_().m_41613_(), 0);
            if (original.m_45352_().m_41783_() != null) {
                convertedEntry.request.advancedNBTData = original.m_45352_().m_41783_().toString();
            }
            if (!original.m_45364_().m_41619_()) {
                convertedEntry.additionalRequest = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45364_().m_41720_()).toString(), original.m_45364_().m_41613_(), 0);
                if (original.m_45364_().m_41783_() != null) {
                    convertedEntry.additionalRequest.advancedNBTData = original.m_45364_().m_41783_().toString();
                }
            }
            convertedEntry.tradeExp = original.m_45379_();
            convertedEntry.maxUses = original.m_45373_();
            convertedEntry.priceMultiplier = original.m_45378_();
            convertedEntry.demand = original.m_45375_();
            convertedEntry.tradeLevel = 1;
            convertedEntry.isRare = false;
            convertedTrades.add(convertedEntry);
        }
        for (j = 0; j < ((VillagerTrades.ItemListing[])existingTrades.get(2)).length; ++j) {
            original = null;
            try {
                original = ((VillagerTrades.ItemListing[])existingTrades.get(2))[j].m_213663_(player, TradeUtil.randomSource);
            }
            catch (NullPointerException e) {
                ModLogger.warn("Could not export a trade entry for wanderer");
                e.printStackTrace();
                continue;
            }
            if (original == null) continue;
            convertedEntry = new MyWandererTrade();
            convertedEntry.offer = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45368_().m_41720_()).toString(), original.m_45368_().m_41613_(), 0);
            if (original.m_45368_().m_41783_() != null) {
                convertedEntry.offer.advancedNBTData = original.m_45368_().m_41783_().toString();
            }
            convertedEntry.request = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45352_().m_41720_()).toString(), original.m_45352_().m_41613_(), 0);
            if (original.m_45352_().m_41783_() != null) {
                convertedEntry.request.advancedNBTData = original.m_45352_().m_41783_().toString();
            }
            if (!original.m_45364_().m_41619_()) {
                convertedEntry.additionalRequest = new MyTradeItem(TradeUtil.getRegistryNameItem(original.m_45364_().m_41720_()).toString(), original.m_45364_().m_41613_(), 0);
                if (original.m_45364_().m_41783_() != null) {
                    convertedEntry.additionalRequest.advancedNBTData = original.m_45364_().m_41783_().toString();
                }
            }
            convertedEntry.tradeExp = original.m_45379_();
            convertedEntry.maxUses = original.m_45373_();
            convertedEntry.priceMultiplier = original.m_45378_();
            convertedEntry.demand = original.m_45375_();
            convertedEntry.tradeLevel = 1;
            convertedEntry.isRare = true;
            convertedTrades.add(convertedEntry);
        }
        coll.trades = convertedTrades.toArray(new MyWandererTrade[convertedTrades.size()]);
        ConfigHandler.exportWandererTradeCollection(coll);
    }

    private static CompletableFuture<Suggestions> professionArgumentSuggestions(CommandContext<CommandSourceStack> c, SuggestionsBuilder b) {
        for (VillagerProfession profession : TradeUtil.getAllProfessions()) {
            b.suggest(TradeUtil.getKeyFromProfession(profession));
        }
        return b.buildFuture();
    }

    private static CompletableFuture<Suggestions> utidArgumentSuggestions(CommandContext<CommandSourceStack> c, SuggestionsBuilder b) {
        for (String key : TradeRegistry.usedUTIDs.keySet()) {
            b.suggest(key);
        }
        return b.buildFuture();
    }

    private static void broadcastMessage(CommandContext<CommandSourceStack> commandContext, String message) {
        ((CommandSourceStack)commandContext.getSource()).m_81377_().m_6846_().m_243063_(PlayerChatMessage.m_247306_((String)message), (CommandSourceStack)commandContext.getSource(), ChatType.m_241073_((ResourceKey)ChatType.f_237006_, (CommandSourceStack)((CommandSourceStack)commandContext.getSource())));
    }
}

