/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class GridRepairOverrides {
    private static final List<Override> OVERRIDES = new ArrayList<Override>();

    public static void onCommonSetup() {
        List values = (List)ModConfigs.GRID_REPAIR_OVERRIDES.get();
        for (String value : values) {
            OverrideIngredient material;
            String[] parts = value.split("=");
            if (parts.length != 2) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax, incorrect amount of arguments (must be 2): {}", (Object)value);
                continue;
            }
            OverrideIngredient tool = OverrideIngredient.parse(parts[0]);
            if (tool == null || (material = OverrideIngredient.parse(parts[1])) == null) continue;
            double multi = GridRepairOverrides.parseMulti(parts[1]);
            OVERRIDES.add(new Override(tool, material, multi));
        }
    }

    public static Override getOverride(ItemStack tool, ItemStack material) {
        for (Override entry : OVERRIDES) {
            if (!entry.tool.is(tool) || !entry.material.is(material)) continue;
            return entry;
        }
        return null;
    }

    public static boolean hasToolOverride(ItemStack tool) {
        return OVERRIDES.stream().anyMatch(o -> o.tool.is(tool));
    }

    private static double parseMulti(String value) {
        if (value.contains("@")) {
            String[] parts = value.split("@");
            try {
                return Double.parseDouble(parts[1]);
            }
            catch (NumberFormatException e) {
                PickleTweaks.LOGGER.error("Invalid repair material multiplier: {}", (Object)value);
            }
        }
        return 1.0;
    }

    public static class OverrideIngredient {
        private final Item item;
        private final TagKey<Item> tag;
        private final OverrideIngredientType type;

        private OverrideIngredient(Item item, TagKey<Item> tag, OverrideIngredientType type) {
            this.item = item;
            this.tag = tag;
            this.type = type;
        }

        public boolean is(ItemStack stack) {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case OverrideIngredientType.ITEM -> stack.m_150930_(this.item);
                case OverrideIngredientType.TAG -> stack.m_204117_(this.tag);
            };
        }

        public static OverrideIngredient item(Item item) {
            return new OverrideIngredient(item, null, OverrideIngredientType.ITEM);
        }

        public static OverrideIngredient tag(TagKey<Item> tag) {
            return new OverrideIngredient(null, tag, OverrideIngredientType.TAG);
        }

        public static OverrideIngredient parse(String value) {
            String[] parts = value.split(":");
            if (parts.length == 3) {
                if (value.startsWith("tag:")) {
                    String tag = value.substring(4).split("@")[0];
                    if (!ResourceLocation.m_135830_((String)tag)) {
                        PickleTweaks.LOGGER.error("Invalid repair material tag: {}", (Object)value);
                        return null;
                    }
                    return OverrideIngredient.tag((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(tag)));
                }
                PickleTweaks.LOGGER.error("Invalid repair material prefix (should be 'tag:'): {}", (Object)value);
            } else {
                if (parts.length == 2) {
                    String id = value.split("@")[0];
                    if (!ResourceLocation.m_135830_((String)id)) {
                        PickleTweaks.LOGGER.error("Invalid repair material item: {}", (Object)value);
                        return null;
                    }
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                    if (item == null) {
                        PickleTweaks.LOGGER.error("Invalid repair material item is null: {}", (Object)value);
                        return null;
                    }
                    return OverrideIngredient.item(item);
                }
                PickleTweaks.LOGGER.error("Invalid repair material syntax: {}", (Object)value);
            }
            return null;
        }
    }

    public static class Override {
        public OverrideIngredient tool;
        public OverrideIngredient material;
        public double multi;

        public Override(OverrideIngredient tool, OverrideIngredient material) {
            this(tool, material, 1.0);
        }

        public Override(OverrideIngredient tool, OverrideIngredient material, double multi) {
            this.tool = tool;
            this.material = material;
            this.multi = multi;
        }
    }

    public static enum OverrideIngredientType {
        ITEM,
        TAG;

    }
}

