/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.serialization.codecs;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ListCodec<A>
implements Codec<List<A>> {
    private final Codec<A> elementCodec;

    public ListCodec(Codec<A> elementCodec) {
        this.elementCodec = elementCodec;
    }

    @Override
    public <T> DataResult<T> encode(List<A> input, DynamicOps<T> ops, T prefix) {
        ListBuilder<T> builder = ops.listBuilder();
        for (A a : input) {
            builder.add(this.elementCodec.encodeStart(ops, a));
        }
        return builder.build(prefix);
    }

    @Override
    public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap((? super R stream) -> {
            ImmutableList.Builder read = ImmutableList.builder();
            Stream.Builder failed = Stream.builder();
            MutableObject result = new MutableObject(DataResult.success(Unit.INSTANCE, Lifecycle.stable()));
            stream.accept(t -> {
                DataResult element = this.elementCodec.decode(ops, t);
                element.error().ifPresent(e -> failed.add(t));
                result.setValue(((DataResult)result.getValue()).apply2stable((r, v) -> {
                    read.add(v.getFirst());
                    return r;
                }, element));
            });
            ImmutableList elements = read.build();
            Object errors = ops.createList(failed.build());
            Pair pair = Pair.of(elements, errors);
            return ((DataResult)result.getValue()).map((? super R unit) -> pair).setPartial(pair);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCodec listCodec = (ListCodec)o;
        return Objects.equals(this.elementCodec, listCodec.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.elementCodec);
    }

    public String toString() {
        return "ListCodec[" + this.elementCodec + "]";
    }
}

