/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.json.ChickenData;

public class AnimalNet
extends Item {
    public AnimalNet() {
        super(new Item.Properties().m_41503_(16));
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemStack, Player playerIn, @NotNull LivingEntity entityIn, @NotNull InteractionHand handIn) {
        NeutralMob mb;
        if (playerIn.m_9236_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("entityCaptured")) {
            return InteractionResult.CONSUME;
        }
        if (entityIn instanceof NeutralMob && (mb = (NeutralMob)entityIn).m_21660_()) {
            return InteractionResult.CONSUME;
        }
        if (entityIn instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)entityIn;
            if (rce.chickenData.ID.equals("grave")) {
                return InteractionResult.CONSUME;
            }
            if (rce.chickenData.ID.equals("angry")) {
                return InteractionResult.CONSUME;
            }
        } else {
            if (entityIn.m_6095_().m_20674_() == MobCategory.MONSTER) {
                return InteractionResult.CONSUME;
            }
            if (entityIn instanceof Player) {
                return InteractionResult.CONSUME;
            }
        }
        CompoundTag compoundStack = itemStack.m_41784_();
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("id", EntityType.m_20613_((EntityType)entityIn.m_6095_()).toString());
        entityIn.m_20240_(compound);
        compound.m_128473_("Motion");
        compound.m_128473_("Rotation");
        compound.m_128473_("Pos");
        compound.m_128350_("maxHealth", entityIn.m_21233_());
        compoundStack.m_128405_("CustomModelData", 1);
        compoundStack.m_128365_("entityCaptured", (Tag)compound);
        if (entityIn instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)entityIn;
            compoundStack.m_128359_("entityDescription", rce.chickenData.displayName.getString());
        } else {
            compoundStack.m_128359_("entityDescription", entityIn.m_6095_().m_20676_().getString());
        }
        playerIn.m_21008_(handIn, itemStack);
        playerIn.m_36346_();
        entityIn.m_5496_(SoundEvents.f_11752_, 1.0f, 1.0f);
        entityIn.m_142687_(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        LivingEntity bird;
        if (context.m_43723_() == null) {
            return InteractionResult.CONSUME;
        }
        CompoundTag compound = context.m_43722_().m_41737_("entityCaptured");
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == initBlocks.NEST_BLOCK.get()) {
            BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
            if (!(blockEntity instanceof NestTileEntity)) {
                return InteractionResult.CONSUME;
            }
            NestTileEntity tile = (NestTileEntity)blockEntity;
            if (tile.entityCaptured != null && compound == null) {
                if (!tile.storedItems.getStackInSlot(5).m_41619_()) {
                    context.m_43725_().m_5594_(null, context.m_43723_().m_20183_(), SoundEvents.f_12507_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.CONSUME;
                }
                context.m_43722_().m_41784_().m_128405_("CustomModelData", 1);
                tile.entityCaptured.m_128405_("EggLayTime", tile.eggLayTime);
                tile.entityCaptured.m_128405_("Age", tile.chickenAge);
                context.m_43722_().m_41784_().m_128365_("entityCaptured", (Tag)tile.entityCaptured);
                context.m_43722_().m_41784_().m_128359_("entityDescription", tile.entityDescription);
                tile.entityRemove(true);
                context.m_43725_().m_5594_(null, context.m_43723_().m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                context.m_43723_().m_36346_();
            } else if (tile.entityCaptured == null && compound != null) {
                ChickenData chickenData = initChickenRegistry.getChickenDataFromEntityID(compound.m_128461_("id"));
                if (chickenData == null) {
                    return InteractionResult.CONSUME;
                }
                tile.entitySet(compound, context.m_43722_().m_41784_().m_128461_("entityDescription"), true);
                context.m_43725_().m_5594_(null, context.m_43723_().m_20183_(), context.m_43725_().f_46441_.m_188499_() ? SoundEvents.f_11752_ : (chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.BLOCKS, 1.0f, 1.0f);
                context.m_43722_().m_41749_("entityCaptured");
                context.m_43722_().m_41749_("entityDescription");
                context.m_43722_().m_41749_("CustomModelData");
                context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), player -> player.m_21190_(context.m_43724_()));
            } else {
                return InteractionResult.CONSUME;
            }
            if (!context.m_43725_().f_46443_) {
                ((ServerLevel)context.m_43725_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)initBlocks.NEST_BLOCK.get()).m_49966_()), (double)context.m_8083_().m_123341_() + 0.5, (double)context.m_8083_().m_123342_() + 0.2, (double)context.m_8083_().m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
            }
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        if (compound == null) {
            return InteractionResult.CONSUME;
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(compound.m_128461_("id")));
        if (type != null && (bird = (LivingEntity)type.m_20615_(context.m_43725_())) != null) {
            BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
            bird.m_20258_(compound);
            bird.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            bird.m_21153_(compound.m_128457_("Health"));
            context.m_43725_().m_7967_((Entity)bird);
            context.m_43725_().m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 1.0f);
            context.m_43725_().m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, pos);
            context.m_43722_().m_41749_("entityCaptured");
            context.m_43722_().m_41749_("entityDescription");
            context.m_43722_().m_41749_("CustomModelData");
            context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), player -> player.m_21190_(context.m_43724_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
        CompoundTag compound = itemStack.m_41737_("entityCaptured");
        if (compound != null) {
            ChickenData conv;
            MutableComponent name;
            if (compound.m_128425_("CustomName", 8) && (name = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"))) != null) {
                tooltip.add((Component)name.m_130940_(ChatFormatting.ITALIC));
            }
            tooltip.add((Component)Component.m_237113_((String)itemStack.m_41783_().m_128461_("entityDescription")));
            if (compound.m_128471_("analyzed")) {
                if (((Boolean)ResourceChickens.CONFIGURATION.compactTips.get()).booleanValue()) {
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.compact", (Object[])new Object[]{compound.m_128451_("gain"), compound.m_128451_("growth"), compound.m_128451_("strength")}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.gain", (Object[])new Object[]{compound.m_128451_("gain")}).m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.growth", (Object[])new Object[]{compound.m_128451_("growth")}).m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.strength", (Object[])new Object[]{compound.m_128451_("strength")}).m_130940_(ChatFormatting.GRAY));
                }
            } else if (compound.m_128461_("id").startsWith("resourcechickens:")) {
                tooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.anal_no").m_130940_(ChatFormatting.GRAY));
            }
            CompoundTag nbt = compound.m_128469_("Mutation");
            if (!nbt.m_128456_() && (conv = initChickenRegistry.getChickenDataFromName(nbt.m_128461_("type"))) != null) {
                tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.conv", (Object[])new Object[]{conv.displayName}).m_130940_(ChatFormatting.GRAY));
            }
            if (compound.m_128441_("Owner")) {
                UUID uuid = compound.m_128342_("Owner");
                if (UsernameCache.containsUUID((UUID)uuid)) {
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.owner", (Object[])new Object[]{UsernameCache.getLastKnownUsername((UUID)uuid)}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.owner_no").m_130940_(ChatFormatting.GRAY));
                }
            }
            if (compound.m_128451_("Age") < 0) {
                tooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.is_baby").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }
}

