/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import wallywhip.resourcechickens.entities.AngryChickenEntity;
import wallywhip.resourcechickens.entities.DuckEggProjectileEntity;
import wallywhip.resourcechickens.entities.EnergyEggProjectileEntity;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;
import wallywhip.resourcechickens.entities.XpEggProjectileEntity;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.items.ChickenSpawnEggItem;
import wallywhip.resourcechickens.json.ChickenData;

public class initChickenRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"resourcechickens");
    public static final Map<String, ChickenData> DATA = new HashMap<String, ChickenData>();
    public static final RegistryObject<EntityType<DuckEggProjectileEntity>> DUCK_EGG = ENTITY_TYPES.register("duck_egg", () -> EntityType.Builder.m_20704_(DuckEggProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_(new ResourceLocation("resourcechickens", "duck_egg").toString()));
    public static final RegistryObject<EntityType<XpEggProjectileEntity>> XP_EGG = ENTITY_TYPES.register("xp_egg", () -> EntityType.Builder.m_20704_(XpEggProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_(new ResourceLocation("resourcechickens", "xp_egg").toString()));
    public static final RegistryObject<EntityType<EnergyEggProjectileEntity>> ENERGY_EGG = ENTITY_TYPES.register("energy_egg", () -> EntityType.Builder.m_20704_(EnergyEggProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_(new ResourceLocation("resourcechickens", "energy_egg").toString()));

    public static void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        DATA.forEach((id, chickenData) -> {
            if (id.equals("angry")) {
                event.put((EntityType)chickenData.entityType.get(), AngryChickenEntity.createChickenAttributes().m_22265_());
            } else {
                event.put((EntityType)chickenData.entityType.get(), ResourceChickenEntity.createChickenAttributes(id).m_22265_());
            }
            SpawnPlacements.m_21754_((EntityType)((EntityType)chickenData.entityType.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, (type, accessor, spawnType, pos, random) -> ResourceChickenEntity.checkAnimalSpawnRules((EntityType<? extends Animal>)type, (LevelAccessor)accessor, spawnType, pos, chickenData));
        });
    }

    public static void registerChicken(String name, ChickenData chickenData) {
        RegistryObject ENTITY = chickenData.isFireImmune ? ENTITY_TYPES.register(name, () -> EntityType.Builder.m_20704_((type, world) -> name.equals("angry") ? new AngryChickenEntity((EntityType<? extends ResourceChickenEntity>)type, world, chickenData) : new ResourceChickenEntity((EntityType<? extends Chicken>)type, world, chickenData), (MobCategory)chickenData.spawnType).m_20699_(0.4f, 0.7f).m_20719_().m_20712_(name)) : ENTITY_TYPES.register(name, () -> EntityType.Builder.m_20704_((type, world) -> name.equals("angry") ? new AngryChickenEntity((EntityType<? extends ResourceChickenEntity>)type, world, chickenData) : new ResourceChickenEntity((EntityType<? extends Chicken>)type, world, chickenData), (MobCategory)chickenData.spawnType).m_20699_(0.4f, 0.7f).m_20712_(name));
        RegistryObject SPAWN_EGG = initItems.ITEMS.register(name + "_chicken_spawn_egg", () -> new ChickenSpawnEggItem((Supplier<? extends EntityType<? extends Mob>>)ENTITY, chickenData));
        DATA.put(name, chickenData);
        chickenData.entityType = ENTITY;
        chickenData.spawnEggItem = SPAWN_EGG;
    }

    @Nullable
    public static ChickenData getChickenDataFromEntityID(String id) {
        for (Map.Entry<String, ChickenData> entry : DATA.entrySet()) {
            if (!entry.getValue().entityType.getId().toString().equals(id)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static ChickenData getChickenDataFromName(String name) {
        return DATA.get(name);
    }
}

