/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.entities;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.items.ChickenCatcher;
import wallywhip.resourcechickens.json.ChickenData;

@ParametersAreNonnullByDefault
public class ResourceChickenEntity
extends Chicken {
    public static final EntityDataAccessor<Boolean> ANALYZED = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GROWTH = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GAIN = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STRENGTH = SynchedEntityData.m_135353_(ResourceChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final TagKey<Item> CHICKEN_FEED = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("resourcechickens", "chicken_feed"));
    public ChickenData chickenData;
    public ChickenData chickenDataCONV;
    public int conversionProgress = 0;
    private static final ResourceKey<DamageType> DAMAGE_RADIATION = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("resourcechickens", "radiation"));
    private static final ResourceKey<DamageType> DAMAGE_EXPLODE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("resourcechickens", "explosion"));
    private static final ResourceKey<DamageType> DAMAGE_THORNS = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("resourcechickens", "thorns"));
    private static final ResourceKey<DamageType> DAMAGE_SHEARS = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("resourcechickens", "shears"));

    public ResourceChickenEntity(EntityType<? extends Chicken> type, Level world, ChickenData chickenData) {
        super(type, world);
        this.chickenData = chickenData;
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        if (this.chickenData.spawnBlocks != null && !this.chickenData.spawnBlocks.isEmpty()) {
            Block block = reader.m_8055_(pos.m_7495_()).m_60734_();
            if (this.chickenData.spawnBlocks.contains(block)) {
                return 10.0f;
            }
            return reader.m_220419_(pos) - 0.5f;
        }
        return 10.0f;
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> type, LevelAccessor accessor, MobSpawnType spawnType, BlockPos pos, ChickenData chickenData) {
        boolean light = chickenData.spawnLight <= 0 ? accessor.m_45524_(pos, 0) <= -chickenData.spawnLight : accessor.m_45524_(pos, 0) >= chickenData.spawnLight;
        boolean isOK = true;
        if (chickenData.spawnBlocks != null && !chickenData.spawnBlocks.isEmpty()) {
            isOK = chickenData.spawnBlocks.contains(accessor.m_8055_(pos.m_7495_()).m_60734_());
        }
        return light && isOK;
    }

    public static AttributeSupplier.Builder createChickenAttributes(String name) {
        ChickenData chickenData = initChickenRegistry.DATA.get(name);
        return ResourceChickenEntity.m_21552_().m_22268_(Attributes.f_22276_, chickenData.baseHealth).m_22268_(Attributes.f_22279_, chickenData.baseSpeed);
    }

    public int m_5792_() {
        return 2;
    }

    @NotNull
    public Component m_7755_() {
        if (this.m_8077_() || this.chickenData == null) {
            return super.m_7755_();
        }
        return this.chickenData.displayName;
    }

    public void m_8107_() {
        super.m_8107_();
        if (((Boolean)ResourceChickens.CONFIGURATION.allowInWorldDrops.get()).booleanValue() && this.chickenData.eggLayTime != 0 && !this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && !this.f_28232_ && --this.f_28231_ <= 0) {
            AtomicBoolean DoIT = new AtomicBoolean(false);
            ResourceChickens.calcDrops((Integer)this.f_19804_.m_135370_(GAIN), this.chickenData, 0).forEach(drop -> {
                if (this.m_19983_((ItemStack)drop) != null) {
                    this.m_146850_(GameEvent.f_157810_);
                    DoIT.set(true);
                }
            });
            if (!this.m_20067_() && DoIT.get()) {
                this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
            this.f_28231_ = ResourceChickens.calcNewEggLayTime(this.f_19796_, this.chickenData, (Integer)this.f_19804_.m_135370_(GROWTH));
        }
        if (this.m_9236_().f_46443_) {
            if (this.chickenData.hasTrait == 2) {
                if (!this.m_20145_()) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
                }
                if (!this.m_20067_() && this.f_19796_.m_188503_(100) == 0) {
                    this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_12286_, SoundSource.NEUTRAL, 0.5f, this.f_19796_.m_188501_() * 0.4f + 0.8f, false);
                }
            } else if (this.chickenData.hasTrait == 5) {
                if (!this.m_20145_()) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_() + 0.7, this.m_20262_(0.5), 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_() + 0.7, this.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
                if (!this.m_20067_() && this.f_19796_.m_188503_(24) == 0) {
                    this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, SoundSource.NEUTRAL, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
                }
            }
        }
    }

    public boolean m_7848_(Animal entityIn) {
        if ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get() == 0) {
            return false;
        }
        if (this.m_27593_() && entityIn.m_27593_() && entityIn instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)entityIn;
            if ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get() == 2) {
                if (!this.chickenData.canBreed) {
                    return false;
                }
                if (!rce.chickenData.canBreed) {
                    return false;
                }
            }
            if (this.chickenData.hasTrait == 1 && rce.chickenData.hasTrait == 1) {
                return true;
            }
            if (this.chickenData.hasTrait == 1 || rce.chickenData.hasTrait == 1) {
                return false;
            }
            if (this.chickenData.ID.equals(rce.chickenData.ID)) {
                return true;
            }
            return (Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get();
        }
        return false;
    }

    @Nullable
    public Chicken m_142606_(ServerLevel worldIn, AgeableMob ageableEntity) {
        ResourceChickenEntity rce = (ResourceChickenEntity)ageableEntity;
        ArrayList<RegistryObject<EntityType<? extends ResourceChickenEntity>>> lst = new ArrayList<RegistryObject<EntityType<? extends ResourceChickenEntity>>>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        lst.add(this.chickenData.entityType);
        weights.add((Integer)this.f_19804_.m_135370_(STRENGTH));
        lst.add(rce.chickenData.entityType);
        weights.add((Integer)rce.f_19804_.m_135370_(STRENGTH));
        String parentA = this.chickenData.entityType.getId().toString();
        String parentB = rce.chickenData.entityType.getId().toString();
        int babyWeight = Integer.max((Integer)this.f_19804_.m_135370_(STRENGTH), (Integer)rce.f_19804_.m_135370_(STRENGTH));
        for (Map.Entry<String, ChickenData> entry : initChickenRegistry.DATA.entrySet()) {
            ChickenData chickenData = entry.getValue();
            if ((!chickenData.parentA.equals(parentA) || !chickenData.parentB.equals(parentB)) && (!chickenData.parentA.equals(parentB) || !chickenData.parentB.equals(parentA))) continue;
            lst.add(chickenData.entityType);
            weights.add(babyWeight);
        }
        if (!lst.isEmpty()) {
            double rndWeight = Math.random() * (double)weights.stream().mapToInt(i -> i).sum();
            int countWeight = 0;
            int chosen = -1;
            while ((double)(countWeight += ((Integer)weights.get(++chosen)).intValue()) < rndWeight) {
            }
            ResourceChickenEntity newChicken = (ResourceChickenEntity)((EntityType)((RegistryObject)lst.get(chosen)).get()).m_20615_((Level)worldIn);
            if (newChicken != null) {
                worldIn.m_5594_(null, this.m_20183_(), SoundEvents.f_11752_, SoundSource.AMBIENT, 1.0f, 1.0f);
                if (this.chickenData.ID.equals(rce.chickenData.ID) || this.chickenData.hasTrait == 1) {
                    ResourceChickenEntity.increaseStats(newChicken, this, rce);
                }
                return newChicken;
            }
        }
        return null;
    }

    public void m_27595_(@Nullable Player player) {
        if (player instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerBreeding.get()).booleanValue()) {
            return;
        }
        super.m_27595_(player);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (damageSource.m_7639_() instanceof FakePlayer) {
            return;
        }
        if (this.chickenData.hasTrait == 3) {
            Level.ExplosionInteraction explosionInteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            DamageSource dd = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DAMAGE_EXPLODE).orElseThrow(), damageSource.m_7639_());
            this.m_9236_().m_254877_((Entity)this, dd, (ExplosionDamageCalculator)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f + (float)((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue() / 2.0f, true, explosionInteraction);
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.chickenData.hasTrait == 1 && damageSource.m_269533_(DamageTypeTags.f_268581_)) {
            return true;
        }
        if (this.chickenData.hasTrait == 4) {
            if (damageSource.m_276093_(DAMAGE_THORNS)) {
                return true;
            }
            if (damageSource.m_276093_(DamageTypes.f_268585_)) {
                return true;
            }
            if (damageSource.m_276093_(DamageTypes.f_268440_)) {
                return true;
            }
        }
        if (this.chickenData.hasTrait == 5 && damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            return true;
        }
        if (this.chickenData.hasTrait == 10 && damageSource.m_269533_(DamageTypeTags.f_268419_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean wasHurt = super.m_6469_(damageSource, amount);
        if (wasHurt && !this.m_9236_().f_46443_) {
            if (this.chickenData.hasTrait == 4) {
                if (damageSource.m_7639_() != null) {
                    DamageSource dd = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DAMAGE_THORNS).orElseThrow(), damageSource.m_7639_());
                    damageSource.m_7639_().m_6469_(dd, 1.0f + (float)((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue() / 2.0f);
                }
            } else if (this.chickenData.hasTrait == 2 && this.m_6084_() && damageSource.m_7639_() instanceof LivingEntity && this.f_19796_.m_188503_(10) != 0) {
                for (int i = 0; i < 64 && !this.teleport(); ++i) {
                }
            }
        }
        return wasHurt;
    }

    protected boolean teleport() {
        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        return this.teleport(d0, d1, d2);
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        boolean flag = blockState.m_280555_();
        boolean flag1 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    protected void m_7625_(DamageSource damageSource, boolean hurtByPlayer) {
        if (damageSource.m_7639_() instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerLootDrops.get()).booleanValue()) {
            return;
        }
        if (this.m_5743_().m_135815_().isEmpty()) {
            return;
        }
        ResourceLocation location = this.chickenData.hasTrait == 1 ? new ResourceLocation("resourcechickens", "entities/duck") : new ResourceLocation("resourcechickens", "entities/chicken");
        LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(location);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_());
        if (hurtByPlayer && this.f_20888_ != null) {
            builder = builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
        }
        LootParams lootParams = builder.m_287235_(LootContextParamSets.f_81415_);
        lootTable.m_287195_(lootParams).forEach(arg_0 -> ((ResourceChickenEntity)this).m_19983_(arg_0));
    }

    protected void m_7472_(DamageSource damageSource, int fortune, boolean allowDrops) {
        if (damageSource.m_7639_() instanceof FakePlayer && !((Boolean)ResourceChickens.CONFIGURATION.allowFakeplayerLootDrops.get()).booleanValue()) {
            return;
        }
        if (!allowDrops || !this.m_5743_().m_135827_().equals("resourcechickens")) {
            return;
        }
        if (this.chickenData.ID.equals("grave")) {
            Entity entity = damageSource.m_7639_();
            if (!(entity instanceof Player)) {
                return;
            }
            Player playerIn = (Player)entity;
            Inventory playerInv = playerIn.m_150109_();
            ListTag lst = this.getPersistentData().m_128437_("Inventory", 10);
            for (int i = 0; i < lst.size(); ++i) {
                CompoundTag compound = lst.m_128728_(i);
                int j = compound.m_128445_("Slot") & 0xFF;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compound);
                if (itemStack.m_41619_()) continue;
                if (j < playerInv.f_35974_.size()) {
                    if (!((ItemStack)playerInv.f_35974_.get(j)).m_41619_()) {
                        playerIn.m_36176_((ItemStack)playerInv.f_35974_.get(j), false);
                    }
                    playerInv.f_35974_.set(j, (Object)itemStack);
                    continue;
                }
                if (j >= 100 && j < playerInv.f_35975_.size() + 100) {
                    if (!((ItemStack)playerInv.f_35975_.get(j - 100)).m_41619_()) {
                        playerIn.m_36176_((ItemStack)playerInv.f_35975_.get(j - 100), false);
                    }
                    playerInv.f_35975_.set(j - 100, (Object)itemStack);
                    continue;
                }
                if (j < 150 || j >= playerInv.f_35976_.size() + 150) continue;
                if (!((ItemStack)playerInv.f_35976_.get(j - 150)).m_41619_()) {
                    playerIn.m_36176_((ItemStack)playerInv.f_35976_.get(j - 150), false);
                }
                playerInv.f_35976_.set(j - 150, (Object)itemStack);
            }
        } else {
            int r = new Random().nextInt(100) + 1;
            if (r <= (Integer)ResourceChickens.CONFIGURATION.allowDeathDropResource.get()) {
                ResourceChickens.calcDrops((Integer)this.f_19804_.m_135370_(GAIN), this.chickenData, fortune).forEach(arg_0 -> ((ResourceChickenEntity)this).m_19983_(arg_0));
            }
        }
    }

    @NotNull
    protected SoundEvent m_7515_() {
        return switch (this.chickenData.hasTrait) {
            case 1 -> (SoundEvent)initSounds.DUCK_AMBIENT.get();
            case 9 -> (SoundEvent)initSounds.RADIATION.get();
            default -> SoundEvents.f_11750_;
        };
    }

    @NotNull
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return switch (this.chickenData.hasTrait) {
            case 1 -> (SoundEvent)initSounds.DUCK_DEATH.get();
            case 5 -> SoundEvents.f_11704_;
            case 6 -> SoundEvents.f_11985_;
            case 7 -> SoundEvents.f_11921_;
            case 8 -> SoundEvents.f_12381_;
            default -> SoundEvents.f_11753_;
        };
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return switch (this.chickenData.hasTrait) {
            case 1 -> (SoundEvent)initSounds.DUCK_DEATH.get();
            case 5 -> SoundEvents.f_11703_;
            case 6 -> SoundEvents.f_11983_;
            case 7 -> SoundEvents.f_11920_;
            case 8 -> SoundEvents.f_12424_;
            default -> SoundEvents.f_11751_;
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANALYZED, (Object)true);
        this.f_19804_.m_135372_(GROWTH, (Object)1);
        this.f_19804_.m_135372_(GAIN, (Object)1);
        this.f_19804_.m_135372_(STRENGTH, (Object)1);
    }

    public void m_7378_(@NotNull CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        if (compoundNBT.m_128441_("analyzed")) {
            this.f_19804_.m_135381_(ANALYZED, (Object)compoundNBT.m_128471_("analyzed"));
            this.f_19804_.m_135381_(GROWTH, (Object)compoundNBT.m_128451_("growth"));
            this.f_19804_.m_135381_(GAIN, (Object)compoundNBT.m_128451_("gain"));
            this.f_19804_.m_135381_(STRENGTH, (Object)compoundNBT.m_128451_("strength"));
        }
        if (compoundNBT.m_128441_("Mutation")) {
            CompoundTag nbt = compoundNBT.m_128469_("Mutation");
            this.conversionProgress = nbt.m_128451_("count");
            this.chickenDataCONV = initChickenRegistry.getChickenDataFromName(nbt.m_128461_("type"));
        }
        if (!compoundNBT.m_128441_("EggLayTime")) {
            this.f_28231_ = ResourceChickens.calcNewEggLayTime(this.f_19796_, this.chickenData, (Integer)this.f_19804_.m_135370_(GROWTH));
        }
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128379_("analyzed", ((Boolean)this.f_19804_.m_135370_(ANALYZED)).booleanValue());
        compoundNBT.m_128405_("growth", ((Integer)this.f_19804_.m_135370_(GROWTH)).intValue());
        compoundNBT.m_128405_("gain", ((Integer)this.f_19804_.m_135370_(GAIN)).intValue());
        compoundNBT.m_128405_("strength", ((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue());
        if (this.conversionProgress != 0) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("count", this.conversionProgress);
            if (this.chickenDataCONV != null) {
                nbt.m_128359_("type", this.chickenDataCONV.ID);
            }
            compoundNBT.m_128365_("Mutation", (Tag)nbt);
        }
    }

    private static void increaseStats(ResourceChickenEntity child, ResourceChickenEntity parentA, ResourceChickenEntity parentB) {
        int strengthA = (Integer)parentA.f_19804_.m_135370_(STRENGTH);
        int strengthB = (Integer)parentB.f_19804_.m_135370_(STRENGTH);
        child.f_19804_.m_135381_(GROWTH, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, (Integer)parentA.f_19804_.m_135370_(GROWTH), (Integer)parentB.f_19804_.m_135370_(GROWTH), child.f_19796_));
        child.f_19804_.m_135381_(GAIN, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, (Integer)parentB.f_19804_.m_135370_(GAIN), (Integer)parentB.f_19804_.m_135370_(GAIN), child.f_19796_));
        child.f_19804_.m_135381_(STRENGTH, (Object)ResourceChickenEntity.calculateNewStat(strengthA, strengthB, strengthA, strengthB, child.f_19796_));
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, RandomSource rand) {
        int mutation = rand.m_188503_(2) + 1;
        int stat = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        return Math.min(stat, 10);
    }

    public void m_146762_(int age) {
        super.m_146762_(this.calcNewAge(age, (Integer)this.f_19804_.m_135370_(GROWTH)));
    }

    public int calcNewAge(int age, int growth) {
        int loveAge;
        boolean resetLoveAfterBreeding;
        boolean resetToChild;
        int childAge = -24000;
        boolean bl = resetToChild = age == childAge;
        if (resetToChild) {
            age = Math.min(-1, childAge * (10 - growth + 1) / 10);
        }
        boolean bl2 = resetLoveAfterBreeding = age == (loveAge = 6000);
        if (resetLoveAfterBreeding) {
            age = Math.max(1, loveAge * (10 - growth + 1) / 10);
        }
        return age;
    }

    protected void m_7324_(Entity entity) {
        entity.m_7334_((Entity)this);
        if (!this.m_9236_().f_46443_) {
            DamageSource dd;
            if (entity instanceof ResourceChickenEntity) {
                ResourceChickenEntity rce = (ResourceChickenEntity)entity;
                if (this.chickenData.hasTrait == rce.chickenData.hasTrait) {
                    return;
                }
            }
            int dmg = (int)(1.0f + (float)((Integer)this.f_19804_.m_135370_(STRENGTH)).intValue() / 2.0f);
            if (this.chickenData.hasTrait == 4) {
                dd = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DAMAGE_THORNS).orElseThrow(), entity);
                entity.m_6469_(dd, (float)dmg);
            }
            if (this.chickenData.hasTrait == 5) {
                entity.m_20254_(dmg);
            }
            if (this.chickenData.hasTrait == 9) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, dmg * 20));
                dd = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DAMAGE_RADIATION).orElseThrow(), entity);
                entity.m_6469_(dd, (float)dmg);
            }
            if (this.chickenData.hasTrait == 10) {
                entity.m_6469_(this.m_269291_().m_269109_(), (float)dmg);
                entity.m_146917_(dmg * 20);
            }
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player playerIn, InteractionHand handIn) {
        ItemStack itemStack;
        InteractionResult ret = super.m_6071_(playerIn, handIn);
        if (InteractionResult.PASS != ret) {
            return ret;
        }
        if (!playerIn.m_9236_().f_46443_ && playerIn.m_7655_() == handIn && !(itemStack = playerIn.m_21205_()).m_41619_()) {
            if (((Boolean)ResourceChickens.CONFIGURATION.allowShearingChickens.get()).booleanValue() && itemStack.canPerformAction(ToolActions.SHEARS_HARVEST)) {
                Level world = playerIn.m_9236_();
                Vec3 pos = this.m_20182_();
                itemStack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                DamageSource dd = new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_203636_(DAMAGE_SHEARS).orElseThrow(), (Entity)this);
                this.m_6469_(dd, 1.0f);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_ + (double)this.m_20192_(), pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.m_5552_(new ItemStack((ItemLike)(this.chickenData.hasTrait == 1 ? (ItemLike)initItems.FEATHER_DUCK.get() : Items.f_42402_)), 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41720_() instanceof ChickenCatcher) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)ResourceChickens.CONFIGURATION.allowConvertingVanilla.get()).booleanValue()) {
                return InteractionResult.FAIL;
            }
            if (!this.chickenData.ID.equals("chicken")) {
                return InteractionResult.FAIL;
            }
            for (Map.Entry<String, ChickenData> entry : initChickenRegistry.DATA.entrySet()) {
                ResourceChickenEntity bird;
                ChickenData chickenData = entry.getValue();
                boolean isMatched = chickenData.conversionRequired != 0 && ResourceChickens.matchDropItem(chickenData.dropItem, itemStack.m_41720_());
                if (!isMatched) continue;
                if (!playerIn.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                ((ServerLevel)playerIn.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 20, 0.5, 0.5, 0.5, 0.0);
                if (this.chickenDataCONV == null || !chickenData.ID.equals(this.chickenDataCONV.ID)) {
                    this.conversionProgress = 1;
                    this.chickenDataCONV = chickenData;
                } else {
                    ++this.conversionProgress;
                }
                if (this.conversionProgress >= chickenData.conversionRequired && (bird = (ResourceChickenEntity)((EntityType)chickenData.entityType.get()).m_20615_(playerIn.m_9236_())) != null) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    playerIn.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.AMBIENT, 1.0f, 1.0f);
                    ((ServerLevel)playerIn.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 100, 1.0, 1.0, 1.0, 0.0);
                    CompoundTag tag = this.m_20240_(new CompoundTag());
                    tag.m_128473_("Dimension");
                    tag.m_128473_("Mutation");
                    tag.m_128473_("UUID");
                    bird.m_20258_(tag);
                    playerIn.m_9236_().m_7967_((Entity)bird);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack itemStack) {
        if (this.chickenData.feedItem.isEmpty()) {
            return itemStack.m_204117_(CHICKEN_FEED);
        }
        if (this.chickenData.feedItemItem != null) {
            return itemStack.m_150930_(this.chickenData.feedItemItem);
        }
        if (this.chickenData.feedItem.startsWith("tag:")) {
            TagKey tagKey;
            ITagManager tagItems;
            ResourceLocation ID = ResourceLocation.m_135820_((String)this.chickenData.feedItem.substring(4));
            if (ID != null && (tagItems = ForgeRegistries.ITEMS.tags()) != null && tagItems.isKnownTagName(tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ID))) {
                return tagItems.getTag(tagKey).contains((Object)itemStack.m_41720_());
            }
            this.chickenData.feedItem = "";
            return false;
        }
        this.chickenData.feedItemItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)this.chickenData.feedItem));
        if (this.chickenData.feedItemItem == null) {
            this.chickenData.feedItem = "";
            return itemStack.m_204117_(CHICKEN_FEED);
        }
        return itemStack.m_150930_(this.chickenData.feedItemItem);
    }
}

