/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import com.google.gson.JsonArray;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.EntityIngredientFactory;
import wallywhip.resourcechickens.compat.JEI.EntityIngredientHelper;
import wallywhip.resourcechickens.compat.JEI.EntityRenderer;
import wallywhip.resourcechickens.compat.JEI.JEIChickenBreedingCategory;
import wallywhip.resourcechickens.compat.JEI.JEIChickenDropsCategory;
import wallywhip.resourcechickens.json.ChickenData;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final IIngredientType<EntityIngredient> ENTITY_INGREDIENT = () -> EntityIngredient.class;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIChickenBreedingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIChickenDropsCategory(helper)});
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("resourcechickens", "jei");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld != null) {
            registration.addRecipes(JEIChickenBreedingCategory.RECIPE, JEIChickenBreedingCategory.getRecipes());
            registration.addRecipes(JEIChickenDropsCategory.RECIPE, JEIChickenDropsCategory.getRecipes());
            this.registerInfoDesc(registration);
        }
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        List<EntityIngredient> entityIngredients = EntityIngredientFactory.create();
        registration.register(ENTITY_INGREDIENT, entityIngredients, (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityRenderer());
    }

    public void registerInfoDesc(IRecipeRegistration registration) {
        for (EntityIngredient chicken : EntityIngredientFactory.create()) {
            ChickenData chickenData = chicken.chickenData;
            StringBuilder stringInformation = new StringBuilder();
            stringInformation.append(Component.m_237110_((String)"jei.resourcechickens.name", (Object[])new Object[]{chickenData.displayName.getString()}).getString()).append("\n");
            stringInformation.append(Component.m_237110_((String)"jei.resourcechickens.health", (Object[])new Object[]{chickenData.baseHealth}).getString()).append("\n");
            stringInformation.append(Component.m_237110_((String)"jei.resourcechickens.speed", (Object[])new Object[]{chickenData.baseSpeed}).getString());
            if (chickenData.eggLayTime > 0) {
                ItemStack itemStack = ResourceChickens.getDropItem(chickenData.dropItem);
                String dropItemDescriptionID = chickenData.dropItem;
                if (!itemStack.m_41619_()) {
                    dropItemDescriptionID = Component.m_237115_((String)itemStack.m_41778_()).getString();
                }
                if (!dropItemDescriptionID.isEmpty()) {
                    stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.drop_item", (Object[])new Object[]{dropItemDescriptionID}).getString());
                    stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.drop_time", (Object[])new Object[]{ResourceChickens.formatTime(chickenData.eggLayTime)}).getString());
                }
            }
            stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.conv", (Object[])new Object[]{chickenData.conversionRequired}).getString());
            String st = switch ((Integer)ResourceChickens.CONFIGURATION.masterSwitchBreeding.get()) {
                case 1 -> Component.m_237115_((String)"jei.true").getString();
                case 2 -> {
                    if (chickenData.canBreed) {
                        yield Component.m_237115_((String)"jei.true").getString();
                    }
                    yield Component.m_237115_((String)"jei.false").getString();
                }
                default -> Component.m_237115_((String)"jei.false").getString();
            };
            stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.breed", (Object[])new Object[]{st}).getString());
            if (chickenData.biomesWhitelist == null && chickenData.biomesBlacklist == null) {
                stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.spawns", (Object[])new Object[]{chickenData.spawnNaturally}).getString());
            } else if (chickenData.spawnNaturally) {
                if (chickenData.biomesWhitelist != null) {
                    stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.spawns_in", (Object[])new Object[]{JEIPlugin.formatBiomeNames(chickenData.biomesWhitelist)}).getString());
                } else {
                    stringInformation.append("\n").append(Component.m_237110_((String)"jei.resourcechickens.spawns_out", (Object[])new Object[]{JEIPlugin.formatBiomeNames(chickenData.biomesBlacklist)}).getString());
                }
            }
            registration.addIngredientInfo((Object)chicken, ENTITY_INGREDIENT, new Component[]{Component.m_237113_((String)stringInformation.toString())});
        }
    }

    private static String formatBiomeNames(JsonArray biomeArray) {
        StringBuilder biome = new StringBuilder();
        for (int a = 0; a < biomeArray.size(); ++a) {
            String n = biomeArray.get(a).toString().replace("\"", "").replace(":", ".");
            biome.append(Component.m_237115_((String)("biome." + n)).getString());
            if (a >= biomeArray.size() - 1) continue;
            biome.append(", ");
        }
        return biome.toString();
    }
}

