/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.JEIPlugin;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.json.ChickenData;

public class JEIChickenDropsCategory
implements IRecipeCategory<Recipe> {
    private static final ResourceLocation GUI_BACK = new ResourceLocation("resourcechickens", "textures/gui/jei.png");
    private static final ResourceLocation GUI_ICONS = new ResourceLocation("resourcechickens", "textures/gui/icons.png");
    private static final ResourceLocation ID = new ResourceLocation("resourcechickens", "drops");
    public static final RecipeType<Recipe> RECIPE = new RecipeType(ID, Recipe.class);
    private final Component localizedName = Component.m_237115_((String)"jei.resourcechickens.drops");
    private final IDrawable background;
    private final IDrawable icon;

    public JEIChickenDropsCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 72, 18).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawable(GUI_ICONS, 16, 0, 16, 16);
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, recipe.dropItems);
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.name));
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        initChickenRegistry.DATA.forEach((id, chickenData) -> {
            ItemStack itemStack;
            if (chickenData.eggLayTime > 0 && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItem)).m_41619_()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                itemStack.m_41751_(chickenData.dropItemNBT);
                items.add(itemStack);
                items.add(new ItemStack((ItemLike)(chickenData.hasTrait == 1 ? (ItemLike)initItems.FEATHER_DUCK.get() : Items.f_42402_)));
                items.add(new ItemStack((ItemLike)initItems.MANURE.get()));
                recipes.add(new Recipe((ChickenData)chickenData, (List<ItemStack>)items));
            }
        });
        return recipes;
    }

    public static class Recipe {
        private final String name;
        private final List<ItemStack> dropItems;

        public Recipe(ChickenData chickenData, @Nullable List<ItemStack> dropItems) {
            this.name = chickenData.ID;
            this.dropItems = dropItems;
        }
    }
}

