/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JADE;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.impl.ui.ProgressStyle;
import snownee.jade.util.Color;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;

public class NestComponentProvider
implements IBlockComponentProvider {
    private static final ResourceLocation ID = new ResourceLocation("resourcechickens");
    private static final IProgressStyle progressStyle = new ProgressStyle().color(Color.rgb((int)137, (int)113, (int)15).toInt(), Color.rgb((int)194, (int)159, (int)14).toInt());

    public void appendTooltip(ITooltip iTooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            CompoundTag data = accessor.getServerData();
            if (tile.entityCaptured != null) {
                if (tile.entityCustomName != null) {
                    iTooltip.add(tile.entityCustomName);
                }
                iTooltip.add(tile.chickenData.displayName);
                if (!tile.storedItems.getStackInSlot(5).m_41619_()) {
                    if (!data.m_128471_("isWarm")) {
                        iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.warm").m_130940_(ChatFormatting.YELLOW));
                        return;
                    }
                    int chickenAge = data.m_128451_("chickenAge");
                    float tt = (float)(24000 + chickenAge) / 24000.0f;
                    iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.growing"));
                    iTooltip.add(iTooltip.getElementHelper().progress(tt, (Component)Component.m_237119_(), progressStyle, (IBoxStyle)BoxStyle.DEFAULT, false));
                    return;
                }
                if (tile.entityCaptured.m_128471_("analyzed")) {
                    if (((Boolean)ResourceChickens.CONFIGURATION.compactTips.get()).booleanValue()) {
                        iTooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.compact", (Object[])new Object[]{tile.chickenGain, tile.chickenGrowth, tile.chickenStrength}));
                    } else {
                        iTooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.gain", (Object[])new Object[]{tile.chickenGain}));
                        iTooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.growth", (Object[])new Object[]{tile.chickenGrowth}));
                        iTooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.strength", (Object[])new Object[]{tile.chickenStrength}));
                    }
                } else {
                    iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.anal_no").m_130940_(ChatFormatting.GRAY));
                }
                int chickenAge = data.m_128451_("chickenAge");
                if (chickenAge < 0) {
                    float tt = (float)(24000 + chickenAge) / 24000.0f;
                    iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.growing"));
                    iTooltip.add(iTooltip.getElementHelper().progress(tt, (Component)Component.m_237119_(), progressStyle, (IBoxStyle)BoxStyle.DEFAULT, false));
                    return;
                }
                if (tile.chickenData.eggLayTime != 0) {
                    if (!data.m_128471_("requiresSeeds")) {
                        iTooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.egg", (Object[])new Object[]{ResourceChickens.formatTime(data.m_128451_("eggTime"))}));
                    }
                } else {
                    iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.no_drop").m_130940_(ChatFormatting.YELLOW));
                }
            }
            if (data.m_128471_("requiresSeeds")) {
                iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.seeds").m_130940_(ChatFormatting.YELLOW));
            } else {
                iTooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.food"));
                iTooltip.add(iTooltip.getElementHelper().progress((float)tile.foodLevel * 0.01f, (Component)Component.m_237119_(), progressStyle, (IBoxStyle)BoxStyle.DEFAULT, false));
            }
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

