/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestItemStackHandler;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.items.LiquidEgg;
import wallywhip.resourcechickens.json.ChickenData;

public class NestTileEntity
extends BlockEntity
implements EntityBlock {
    public NestItemStackHandler storedItems = new NestItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NestTileEntity.this.m_6596_();
            if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue()) {
                NestTileEntity.this.sendRenderUpdates();
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0) {
                int limit = 100 - NestTileEntity.this.foodLevel;
                if (limit <= 0) {
                    return stack;
                }
                int amountToCopy = Integer.min(limit, stack.m_41613_());
                ItemStack items = this.insertItem(slot, stack, simulate, amountToCopy);
                if (!simulate) {
                    NestTileEntity.this.foodLevel += amountToCopy;
                    this.stacks.set(0, (Object)ItemStack.f_41583_);
                    NestTileEntity.this.m_6596_();
                    NestTileEntity.this.sendRenderUpdates();
                }
                return items;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, int limit) {
            boolean reachedLimit;
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.m_41613_();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.m_41613_() > limit;
            if (!simulate) {
                if (existing.m_41619_()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                }
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                if (NestTileEntity.this.chickenData != null) {
                    if (NestTileEntity.this.chickenData.feedItem.isEmpty()) {
                        return stack.m_204117_(ResourceChickenEntity.CHICKEN_FEED);
                    }
                    return stack.m_150930_(NestTileEntity.this.chickenData.feedItemItem);
                }
                return stack.m_204117_(ResourceChickenEntity.CHICKEN_FEED);
            }
            if (slot == 5) {
                return stack.m_150930_(Items.f_42521_) || stack.m_150930_((Item)initItems.EGG_DUCK.get()) || stack.m_150930_((Item)initItems.ENERGY_EGG.get());
            }
            return false;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            if (slot == 5) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    public ChickenData chickenData = null;
    public CompoundTag entityCaptured = null;
    public String entityDescription = "";
    public Component entityCustomName = null;
    public ResourceLocation chickenTexture = null;
    public int eggLayTime;
    public int chickenAge;
    public int chickenGrowth;
    public int chickenGain;
    public int chickenStrength;
    public int foodLevel = 0;
    public boolean analyzed = false;
    public boolean isWarm = false;

    public NestTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)initTiles.NEST_BLOCK_TILE.get(), pos, state);
    }

    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new NestTileEntity(blockPos, blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.storedItems).cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.m_183515_(compound);
        return compound;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Inventory")) {
            compound.m_128469_("Inventory").m_128405_("Size", 6);
            this.storedItems.deserializeNBT(compound.m_128469_("Inventory"));
        }
        if (compound.m_128441_("foodLevel")) {
            this.foodLevel = compound.m_128451_("foodLevel");
        }
        if (compound.m_128441_("entityCaptured")) {
            this.entitySet(compound.m_128469_("entityCaptured"), compound.m_128461_("entityDescription"), false);
        } else {
            this.entityRemove(false);
        }
        if (compound.m_128441_("isWarm")) {
            this.isWarm = compound.m_128471_("isWarm");
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.storedItems.serializeNBT());
        compound.m_128405_("foodLevel", this.foodLevel);
        compound.m_128379_("isWarm", this.isWarm);
        if (this.entityCaptured != null) {
            this.entityCaptured.m_128405_("EggLayTime", this.eggLayTime);
            this.entityCaptured.m_128405_("Age", this.chickenAge);
            compound.m_128365_("entityCaptured", (Tag)this.entityCaptured);
            compound.m_128359_("entityDescription", this.entityDescription);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void entityRemove(boolean sendUpdates) {
        this.chickenGrowth = 0;
        this.chickenGain = 0;
        this.chickenStrength = 0;
        this.analyzed = false;
        this.chickenAge = 0;
        this.eggLayTime = 0;
        this.chickenData = null;
        this.entityCaptured = null;
        this.entityDescription = "";
        this.entityCustomName = null;
        this.storedItems.setStackInSlot(5, ItemStack.f_41583_);
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
        this.m_6596_();
    }

    public void entitySet(CompoundTag compound, String desc, boolean sendUpdates) {
        MutableComponent name;
        this.entityCaptured = compound.m_6426_();
        this.entityDescription = desc;
        this.chickenData = initChickenRegistry.getChickenDataFromEntityID(compound.m_128461_("id"));
        if (this.storedItems.getStackInSlot(5).m_41619_()) {
            this.chickenTexture = ResourceChickens.getTexture(this.chickenData, compound.m_128342_("UUID"));
        }
        if (compound.m_128441_("CustomName") && (name = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"))) != null) {
            this.entityCustomName = name.m_130940_(ChatFormatting.ITALIC);
        }
        this.eggLayTime = compound.m_128451_("EggLayTime");
        this.chickenAge = compound.m_128451_("Age");
        this.chickenGrowth = compound.m_128451_("growth");
        this.chickenGain = compound.m_128451_("gain");
        this.chickenStrength = compound.m_128451_("strength");
        this.analyzed = compound.m_128471_("analyzed");
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
        this.m_6596_();
    }

    public void sendRenderUpdates() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void entitySetCustomName(CompoundTag compound) {
        if (compound != null && compound.m_128425_("Name", 8)) {
            try {
                String name = compound.m_128461_("Name");
                MutableComponent component = Component.Serializer.m_130701_((String)name);
                if (component != null) {
                    this.entityCaptured.m_128359_("CustomName", name);
                    this.entityCustomName = component.m_6881_().m_130940_(ChatFormatting.ITALIC);
                    this.m_6596_();
                    return;
                }
            }
            catch (JsonParseException e) {
                compound.m_128473_("Name");
            }
        }
        this.entityCaptured.m_128473_("CustomName");
        this.entityCustomName = null;
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestTileEntity tile) {
        boolean isDirty = false;
        ItemStack eggStack = tile.storedItems.getStackInSlot(5);
        if (!eggStack.m_41619_()) {
            ChickenData data;
            if (tile.entityCaptured == null && (data = eggStack.m_150930_((Item)initItems.EGG_DUCK.get()) ? initChickenRegistry.DATA.get("duck") : (eggStack.m_150930_((Item)initItems.ENERGY_EGG.get()) ? initChickenRegistry.DATA.get("energy") : initChickenRegistry.DATA.get("chicken"))) != null) {
                CompoundTag compound = new CompoundTag();
                compound.m_128359_("id", data.entityType.getKey().m_135782_().toString());
                compound.m_128405_("Age", -24000);
                tile.chickenAge = -24000;
                if (eggStack.m_41788_()) {
                    Component component = eggStack.m_41786_();
                    compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)component));
                }
                tile.entitySet(compound, data.displayName.getString(), true);
            }
            if (!tile.isWarm) {
                return;
            }
            if (tile.chickenAge < 0) {
                ++tile.chickenAge;
                if (tile.chickenAge >= 0) {
                    AgeableMob bird = (AgeableMob)((EntityType)tile.chickenData.entityType.get()).m_20615_(level);
                    if (bird != null) {
                        ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                        level.m_5594_(null, pos, level.f_46441_.m_188499_() ? SoundEvents.f_11752_ : (tile.chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.BLOCKS, 1.0f, 1.0f);
                        bird.m_20258_(tile.entityCaptured);
                        bird.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        bird.m_6863_(true);
                        level.m_7967_((Entity)bird);
                    }
                    tile.entityRemove(true);
                    tile.storedItems.setStackInSlot(5, ItemStack.f_41583_);
                    return;
                }
                tile.m_6596_();
                return;
            }
        }
        if (tile.entityCaptured == null) {
            return;
        }
        if (tile.chickenAge < 0) {
            ++tile.chickenAge;
            if (tile.chickenAge >= 0) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                level.m_5594_(null, pos, level.f_46441_.m_188499_() ? SoundEvents.f_11752_ : (tile.chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.BLOCKS, 1.0f, 1.0f);
                tile.eggLayTime = ResourceChickens.calcNewEggLayTime(level.f_46441_, tile.chickenData, tile.chickenGrowth);
                tile.sendRenderUpdates();
                isDirty = true;
            }
        }
        if (tile.chickenData.eggLayTime != 0 && tile.chickenAge >= 0) {
            boolean isOK = true;
            if (((Boolean)ResourceChickens.CONFIGURATION.seededChamber.get()).booleanValue()) {
                boolean bl = isOK = tile.foodLevel != 0;
            }
            if (isOK) {
                --tile.eggLayTime;
                if (tile.eggLayTime == 0) {
                    LazyOptional lazyItem;
                    tile.eggLayTime = ResourceChickens.calcNewEggLayTime(level.f_46441_, tile.chickenData, tile.chickenGrowth);
                    List<ItemStack> DROPS = ResourceChickens.calcDrops(tile.chickenGain, tile.chickenData, 0);
                    if (DROPS.isEmpty()) {
                        return;
                    }
                    if (((Boolean)ResourceChickens.CONFIGURATION.seededChamber.get()).booleanValue()) {
                        --tile.foodLevel;
                    }
                    isDirty = true;
                    BlockPos posBelow = pos.m_7495_();
                    BlockState downState = level.m_8055_(posBelow);
                    boolean isCauldron = downState.m_60734_() instanceof AbstractCauldronBlock;
                    BlockEntity outputTILE = level.m_7702_(posBelow);
                    LazyOptional lazyFluid = LazyOptional.empty();
                    LazyOptional lazyEnergy = LazyOptional.empty();
                    if (outputTILE != null) {
                        lazyFluid = outputTILE.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP);
                        lazyEnergy = outputTILE.getCapability(ForgeCapabilities.ENERGY, Direction.UP);
                    }
                    for (ItemStack itm : DROPS) {
                        Item item = itm.m_41720_();
                        if (item instanceof LiquidEgg) {
                            LiquidEgg le = (LiquidEgg)item;
                            if (isCauldron) {
                                BlockState newState;
                                if (le.fluidType == Fluids.f_76193_) {
                                    newState = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                                    level.m_46597_(posBelow, newState);
                                    level.m_220407_(GameEvent.f_157792_, posBelow, GameEvent.Context.m_223722_((BlockState)newState));
                                    itm.m_41774_(1);
                                    continue;
                                }
                                if (le.fluidType != Fluids.f_76195_) continue;
                                newState = Blocks.f_152477_.m_49966_();
                                level.m_46597_(posBelow, newState);
                                level.m_220407_(GameEvent.f_157792_, posBelow, GameEvent.Context.m_223722_((BlockState)newState));
                                itm.m_41774_(1);
                                continue;
                            }
                            if (!lazyFluid.isPresent()) continue;
                            FluidStack fluidStack = new FluidStack(le.fluidType, 1000);
                            for (int a = 0; a < itm.m_41613_(); ++a) {
                                lazyFluid.ifPresent(handler -> {
                                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE) > 0) {
                                        itm.m_41774_(1);
                                    }
                                });
                            }
                            continue;
                        }
                        if (itm.m_150930_(Items.f_42589_)) {
                            Potion potion = PotionUtils.m_43579_((ItemStack)itm);
                            if (potion != Potions.f_43599_ && potion != Potions.f_43598_) continue;
                            if (isCauldron) {
                                int f = (Integer)downState.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1;
                                if (f < 4) {
                                    BlockState newState = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(f));
                                    level.m_46597_(posBelow, newState);
                                    level.m_220407_(GameEvent.f_157792_, posBelow, GameEvent.Context.m_223722_((BlockState)newState));
                                }
                                itm.m_41774_(1);
                                continue;
                            }
                            if (!lazyFluid.isPresent()) continue;
                            FluidStack fluidStack = new FluidStack((Fluid)Fluids.f_76193_, 333);
                            for (int a = 0; a < itm.m_41613_(); ++a) {
                                lazyFluid.ifPresent(handler -> {
                                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE) > 0) {
                                        itm.m_41774_(1);
                                    }
                                });
                            }
                            continue;
                        }
                        if (!itm.m_150930_((Item)initItems.ENERGY_EGG.get())) continue;
                        lazyEnergy.ifPresent(handler -> itm.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(egg -> {
                            int amount = handler.receiveEnergy(egg.getEnergyStored(), false);
                            egg.extractEnergy(amount, false);
                            if (egg.getEnergyStored() == 0) {
                                itm.m_41774_(1);
                            }
                        }));
                    }
                    if (outputTILE != null && (lazyItem = outputTILE.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP)).isPresent()) {
                        tile.storedItems.getStacks().replaceAll(stack -> lazyItem.map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false)).orElse(ItemStack.f_41583_));
                        DROPS.replaceAll(stack -> lazyItem.map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false)).orElse(ItemStack.f_41583_));
                    }
                    if (downState.m_60713_(Blocks.f_50715_) && !level.f_46443_) {
                        BlockState returnState;
                        int COUNT;
                        BlockState oldState = downState;
                        block3: for (ItemStack stack2 : tile.storedItems.getStacks()) {
                            COUNT = stack2.m_41613_();
                            for (int a = 0; a < COUNT; ++a) {
                                if ((Integer)oldState.m_61143_((Property)ComposterBlock.f_51913_) == 7) break block3;
                                returnState = ComposterBlock.m_268990_((Entity)null, (BlockState)oldState, (ServerLevel)((ServerLevel)level), (ItemStack)stack2, (BlockPos)posBelow);
                                level.m_46796_(1500, posBelow, returnState != oldState ? 1 : 0);
                                oldState = returnState;
                            }
                        }
                        block5: for (ItemStack stack2 : DROPS) {
                            COUNT = stack2.m_41613_();
                            for (int a = 0; a < COUNT; ++a) {
                                if ((Integer)oldState.m_61143_((Property)ComposterBlock.f_51913_) == 7) break block5;
                                returnState = ComposterBlock.m_268990_((Entity)null, (BlockState)oldState, (ServerLevel)((ServerLevel)level), (ItemStack)stack2, (BlockPos)posBelow);
                                level.m_46796_(1500, posBelow, returnState != oldState ? 1 : 0);
                                oldState = returnState;
                            }
                        }
                    }
                    DROPS.replaceAll(stack -> tile.storedItems.insertItemDrop((ItemStack)stack));
                    if (!DROPS.isEmpty() && ((Boolean)ResourceChickens.CONFIGURATION.spurtingChamber.get()).booleanValue()) {
                        DROPS.forEach(stack -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack));
                    }
                    if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue()) {
                        tile.sendRenderUpdates();
                    }
                }
            }
        }
        if (isDirty) {
            tile.m_6596_();
        }
    }
}

