/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.api.utils.CurioUtils;
import com.gametechbc.traveloptics.entity.mobs.EnragedDeadKingBoss;
import com.gametechbc.traveloptics.entity.spells.AcidRainAoe;
import com.gametechbc.traveloptics.entity.spells.RainfallAoe;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.TargetedTargetAreaCastData;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class RainfallSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "rainfall");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(3).setCooldownSeconds(60.0).build();

    public RainfallSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.THUNDERSTORM_PREPARE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.AQUA_CAST_2.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (!Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f, (boolean)false)) {
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(entity));
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success_self", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
        }
        float radius = this.getRadius(spellLevel);
        LivingEntity target = ((TargetEntityCastData)playerMagicData.getAdditionalCastData()).getTarget((ServerLevel)level);
        TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)target.m_20182_(), (float)radius, (int)Utils.packRGB((Vector3f)this.getTargetingColor()), (Entity)target);
        playerMagicData.setAdditionalCastData((ICastData)new TargetedTargetAreaCastData(target, area));
        return true;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetedTargetAreaCastData targetData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetedTargetAreaCastData && (targetEntity = (targetData = (TargetedTargetAreaCastData)iCastData).getTarget((ServerLevel)world)) != null) {
            if (CurioUtils.getWearingCurio(entity, (Item)TravelopticsItems.BOTTLED_RAINCLOUD.get()) || entity instanceof EnragedDeadKingBoss) {
                AcidRainAoe acidRainAoe = new AcidRainAoe(world);
                acidRainAoe.m_5602_((Entity)entity);
                acidRainAoe.setRadius(this.getRadius(spellLevel));
                acidRainAoe.setDuration(this.getDuration() + 40);
                acidRainAoe.setCorrodedEffectAmplifier(this.getWetAmplifier(spellLevel, entity));
                acidRainAoe.setCircular();
                acidRainAoe.m_146884_(targetEntity.m_20182_());
                world.m_7967_((Entity)acidRainAoe);
            } else {
                RainfallAoe rainfallAoe = new RainfallAoe(world);
                rainfallAoe.m_5602_((Entity)entity);
                rainfallAoe.setRadius(this.getRadius(spellLevel));
                rainfallAoe.setDuration(this.getDuration());
                rainfallAoe.setWetEffectAmplifier(this.getWetAmplifier(spellLevel, entity));
                rainfallAoe.setCircular();
                rainfallAoe.m_146884_(targetEntity.m_20182_());
                world.m_7967_((Entity)rainfallAoe);
            }
            super.onCast(world, spellLevel, entity, castSource, playerMagicData);
        }
    }

    private float getRadius(int spellLevel) {
        return 2 + spellLevel * 2;
    }

    private int getWetAmplifier(int spellLevel, LivingEntity caster) {
        return (int)(0.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f);
    }

    private int getDuration() {
        return 100;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel), (int)2)}), Component.m_237110_((String)"ui.traveloptics.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(), (int)2)}), Component.m_237110_((String)"ui.traveloptics.wet_amplifier", (Object[])new Object[]{Utils.stringTruncation((double)this.getWetAmplifier(spellLevel, caster), (int)1)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public boolean stopSoundOnCancel() {
        return true;
    }
}

