/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.api.spells.AdvancedSpell;
import com.gametechbc.traveloptics.entity.spells.hydroshot.HydroshotProjectile;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class HydroshotSpell
extends AdvancedSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "hydroshot");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(10).setCooldownSeconds(1.0).build();

    public HydroshotSpell() {
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 12;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 10;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        HydroshotProjectile hydroShot = new HydroshotProjectile(world, entity);
        hydroShot.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - hydroShot.m_20191_().m_82376_() * 0.5, 0.0));
        hydroShot.shoot(entity.m_20154_());
        hydroShot.setDamage(this.getDamage(spellLevel, entity));
        hydroShot.setSlownessAmplifier(this.getSlowness(spellLevel));
        world.m_7967_((Entity)hydroShot);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.5f;
    }

    private int getSlowness(int spellLevel) {
        return spellLevel / 10;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.traveloptics.slowness_amplifier", (Object[])new Object[]{Utils.stringTruncation((double)this.getSlowness(spellLevel), (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

