/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.setup;

import com.gametechbc.traveloptics.init.TravelopticsAugments;
import com.gametechbc.traveloptics.init.TravelopticsBlessedAugments;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AugmentTooltipsHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        AugmentTooltipsHandler.execute((Event)event, event.getItemStack(), event.getToolTip());
    }

    public static void execute(ItemStack itemstack, List<Component> tooltip) {
        AugmentTooltipsHandler.execute(null, itemstack, tooltip);
    }

    private static void execute(@Nullable Event event, ItemStack itemstack, List<Component> tooltip) {
        if (tooltip == null) {
            return;
        }
        if (AugmentTooltipsHandler.isEpicAugment(itemstack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.augment.epic.desc"));
        } else if (AugmentTooltipsHandler.isLegendaryAugment(itemstack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.augment.legendary.desc"));
        } else if (AugmentTooltipsHandler.isMythicAugment(itemstack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.augment.mythic.desc"));
        } else if (AugmentTooltipsHandler.isBlessedAugment(itemstack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.augment.blessed.desc"));
        }
    }

    private static boolean isEpicAugment(ItemStack itemstack) {
        return itemstack.m_41720_() == TravelopticsAugments.AUGMENT_VOLCANA_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_RIFTCORE_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_SACRED_VOID_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_OBLIVION_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_CHAOS_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_LIFEDRAIN_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_EQUILIBRIUM_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_BALANCE_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_FRIGID_FLAME_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_THUNDERBOLT_EPIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_REFRESHMENT_EPIC.get();
    }

    private static boolean isLegendaryAugment(ItemStack itemstack) {
        return itemstack.m_41720_() == TravelopticsAugments.AUGMENT_VOLCANA_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_RIFTCORE_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_SACRED_VOID_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_OBLIVION_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_CHAOS_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_LIFEDRAIN_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_EQUILIBRIUM_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_BALANCE_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_FRIGID_FLAME_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_THUNDERBOLT_LEGENDARY.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_REFRESHMENT_LEGENDARY.get();
    }

    private static boolean isMythicAugment(ItemStack itemstack) {
        return itemstack.m_41720_() == TravelopticsAugments.AUGMENT_VOLCANA_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_RIFTCORE_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_SACRED_VOID_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_OBLIVION_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_CHAOS_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_LIFEDRAIN_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_EQUILIBRIUM_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_BALANCE_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_FRIGID_FLAME_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_THUNDERBOLT_MYTHIC.get() || itemstack.m_41720_() == TravelopticsAugments.AUGMENT_REFRESHMENT_MYTHIC.get();
    }

    private static boolean isBlessedAugment(ItemStack itemstack) {
        return itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_VOLCANA_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_RIFTCORE_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_SACRED_VOID_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_OBLIVION_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_CHAOS_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_LIFEDRAIN_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_EQUILIBRIUM_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_BALANCE_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_FRIGID_FLAME_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_THUNDERBOLT_BLESSED.get() || itemstack.m_41720_() == TravelopticsBlessedAugments.AUGMENT_REFRESHMENT_BLESSED.get();
    }
}

