/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.trident_of_the_eternal_maelstrom;

import com.gametechbc.traveloptics.api.init.TravelopticsAttributes;
import com.gametechbc.traveloptics.api.item.GeoMagicSpearItem;
import com.gametechbc.traveloptics.config.WeaponConfig;
import com.gametechbc.traveloptics.entity.item.trident_of_the_eternal_maelstrom.evo_three.EternalMaelstromTridentLevelThreeItemRenderer;
import com.gametechbc.traveloptics.entity.projectiles.aqua_trident.EternalMaelstromTridentEntity;
import com.gametechbc.traveloptics.entity.spells.tidal_slash.TidalSlashProjectile;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.gametechbc.traveloptics.item.UnbreakableGeoMagicSpear;
import com.github.L_Ender.cataclysm.items.ILeftClick;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TridentOfTheEternalMaelstromLevelThreeItem
extends UnbreakableGeoMagicSpear
implements ILeftClick {
    private static ItemDisplayContext transformType;

    public TridentOfTheEternalMaelstromLevelThreeItem(Item.Properties properties) {
        super(properties, (Double)WeaponConfig.eternalMaelstromDamage.get());
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        Multimap<Attribute, AttributeModifier> modifiers = super.m_7167_(equipmentSlot);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)TravelopticsAttributes.AQUA_SPELL_POWER.get()), (Object)new AttributeModifier(UUID.fromString("fa2337fd-b888-4c1c-8a4e-3b7d4b74b2d9"), "Weapon boost", ((Double)WeaponConfig.eternalMaelstromAquaSpellPower.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE));
            return builder.build();
        }
        return modifiers;
    }

    @Override
    protected int getMaxSpellSlots() {
        return 1;
    }

    @Override
    protected Map<AbstractSpell, GeoMagicSpearItem.SpellData> getSpellsToAdd() {
        return Map.of((AbstractSpell)TravelopticsSpells.TIDAL_SLASH_SPELL.get(), new GeoMagicSpearItem.SpellData(1, true));
    }

    private boolean isCharged(Player player, ItemStack stack) {
        return player.m_36403_(0.5f) > 0.9f;
    }

    public boolean onLeftClick(ItemStack stack, LivingEntity playerIn) {
        if (stack.m_150930_((Item)TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_THREE.get()) && playerIn.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_THREE.get()) && (!(playerIn instanceof Player) || this.isCharged((Player)playerIn, stack)) && playerIn.m_21023_((MobEffect)TravelopticsEffects.TIDAL_SLASH.get())) {
            return this.doSlash(playerIn.m_9236_(), playerIn);
        }
        return false;
    }

    private boolean doSlash(Level world, LivingEntity entity) {
        boolean success = false;
        if (!world.f_46443_) {
            int amplifier = 0;
            if (entity.m_21023_((MobEffect)TravelopticsEffects.TIDAL_SLASH.get())) {
                amplifier = entity.m_21124_((MobEffect)TravelopticsEffects.TIDAL_SLASH.get()).m_19564_();
            }
            float damage = amplifier;
            float manaGain = damage * 0.1f;
            TidalSlashProjectile floodSlash = new TidalSlashProjectile(world, entity);
            floodSlash.m_146884_(entity.m_146892_());
            floodSlash.shoot(entity.m_20154_());
            floodSlash.setDamage(damage);
            floodSlash.setManaGain(manaGain);
            world.m_7967_((Entity)floodSlash);
            success = true;
        }
        world.m_6269_(null, (Entity)entity, (SoundEvent)ACSoundRegistry.SEA_STAFF_CAST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return success;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int i1) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int i = this.m_8105_(itemStack) - i1;
            float f = this.getPowerForTime(i);
            if ((double)f > 0.1) {
                itemStack.m_41622_(1, livingEntity, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                EternalMaelstromTridentEntity spearEntity = new EternalMaelstromTridentEntity(level, (LivingEntity)player, itemStack);
                spearEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.5f, 1.0f);
                if (player.m_150110_().f_35937_) {
                    spearEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                double aquaSpellPower = player.m_21133_((Attribute)TravelopticsAttributes.AQUA_SPELL_POWER.get());
                double effectivePower = Math.max(0.0, aquaSpellPower - 1.0);
                float baseBoltStrikeDamage = 8.0f;
                float maxBoltStrikeDamage = 18.0f;
                float scaledBoltStrikeDamage = (float)((double)baseBoltStrikeDamage + 4.0 * effectivePower + 2.0 * Math.sqrt(effectivePower));
                scaledBoltStrikeDamage = Math.min(scaledBoltStrikeDamage, maxBoltStrikeDamage);
                spearEntity.setTridentDamage(((Double)WeaponConfig.eternalMaelstromDamage.get()).floatValue() + 4.0f);
                spearEntity.setAoeDamageMultiplier(0.75f);
                spearEntity.setBoltstrikeDamage(scaledBoltStrikeDamage * ((Double)WeaponConfig.eternalMaelstromBoltstrikeDamageMultiplier.get()).floatValue());
                level.m_7967_((Entity)spearEntity);
                level.m_6269_(null, (Entity)spearEntity, (SoundEvent)TravelopticsSounds.MAELSTROM_TRIDENT_THROW.get(), SoundSource.PLAYERS, 0.9f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public int m_6473_() {
        return 15;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public boolean m_6832_(ItemStack item, ItemStack repairItem) {
        return repairItem.m_150930_((Item)TravelopticsItems.HULLBREAKER_STEEL.get()) || super.m_6832_(item, repairItem);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.trident_of_the_eternal_maelstrom.tooltip").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.trident_of_the_eternal_maelstrom.tooltip4"));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution_benefits.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.trident_of_the_eternal_maelstrom.evo_one.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.trident_of_the_eternal_maelstrom.evo_two.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.trident_of_the_eternal_maelstrom.evo_three.active.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution.stars_three.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        super.m_7373_(stack, world, tooltip, flag);
    }

    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer getRenderer() {
        return new EternalMaelstromTridentLevelThreeItemRenderer();
    }
}

