/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.events;

import com.gametechbc.traveloptics.ClientProxy;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="traveloptics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEvents {
    private static final float[] VIOLET_SKY_COLOR = new float[]{0.25f, 0.0f, 0.45f};
    private static final ResourceLocation BOSS_BAR_HUD_OVERLAYS = new ResourceLocation("alexscaves", "textures/misc/boss_bar_hud_overlays.png");

    @SubscribeEvent
    public static void onFovModifierEvent(ComputeFovModifierEvent event) {
        Player entity = event.getPlayer();
        if (entity.m_21023_((MobEffect)TravelopticsEffects.HOVERING_EFFECT.get())) {
            event.setNewFovModifier(1.0f);
        }
    }

    @SubscribeEvent
    public static void onSkyRender(ViewportEvent.ComputeFogColor event) {
        MobEffectInstance effect;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (effect = mc.f_91074_.m_21124_((MobEffect)TravelopticsEffects.ASTRAL_SENSE_TREASURE.get())) != null) {
            event.setRed(VIOLET_SKY_COLOR[0]);
            event.setGreen(VIOLET_SKY_COLOR[1]);
            event.setBlue(VIOLET_SKY_COLOR[2]);
        }
        if (mc.f_91074_ != null && (effect = mc.f_91074_.m_21124_((MobEffect)TravelopticsEffects.ASTRAL_SENSE.get())) != null) {
            event.setRed(VIOLET_SKY_COLOR[0]);
            event.setGreen(VIOLET_SKY_COLOR[1]);
            event.setBlue(VIOLET_SKY_COLOR[2]);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderBossOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (ClientProxy.bossBarRenderTypes.containsKey(event.getBossEvent().m_18860_())) {
            int renderTypeFor = ClientProxy.bossBarRenderTypes.get(event.getBossEvent().m_18860_());
            int i = event.getGuiGraphics().m_280182_();
            int j = event.getY();
            Component component = event.getBossEvent().m_18861_();
            if (renderTypeFor == 0) {
                event.setCanceled(true);
                event.getGuiGraphics().m_280218_(BOSS_BAR_HUD_OVERLAYS, event.getX(), event.getY(), 0, 0, 182, 15);
                int progressScaled = (int)(event.getBossEvent().m_142717_() * 183.0f);
                event.getGuiGraphics().m_280218_(BOSS_BAR_HUD_OVERLAYS, event.getX(), event.getY(), 0, 15, progressScaled, 15);
                int l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                int i1 = i / 2 - l / 2;
                int j1 = j - 9;
                PoseStack poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)i1, (float)j1, 0.0f);
                Minecraft.m_91087_().f_91062_.m_168645_(component.m_7532_(), 0.0f, 0.0f, 16732416, 3544341, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 240);
                poseStack.m_85849_();
                event.setIncrement(event.getIncrement() + 7);
            }
        }
    }
}

