/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.spells;

import com.gametechbc.traveloptics.config.CommonConfig;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class RainfallAoe
extends AoeEntity
implements AntiMagicSusceptible {
    private int wetEffectAmplifier = 0;
    private int tickCounter;

    public static List<? extends String> getImmuneEffectsList() {
        return (List)CommonConfig.rainfallImmuneEffects.get();
    }

    public RainfallAoe(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public RainfallAoe(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)TravelopticsEntities.RAINFALL_ENTITY.get()), level);
    }

    public int getWetEffectAmplifier() {
        return this.wetEffectAmplifier;
    }

    public void setWetEffectAmplifier(int wetEffectAmplifier) {
        this.wetEffectAmplifier = wetEffectAmplifier;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.tickCounter;
        if (!this.m_9236_().f_46443_ && this.tickCounter == 1) {
            this.m_5496_((SoundEvent)TravelopticsSounds.RAINFALL_ACTIVE.get(), 1.5f, 1.0f);
        }
        if (this.f_19797_ % 5 == 0) {
            this.cleanseEntities();
            this.applyWetEffectToEntities();
            this.extinguishEntitiesFire();
        }
        this.spawnRainParticles();
        if (this.f_19797_ % 5 == 0) {
            this.spawnCloudParticles();
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= 100) {
            this.m_146870_();
        }
    }

    private void applyWetEffectToEntities() {
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), entity -> entity instanceof LivingEntity).forEach(entity -> {
            LivingEntity target = (LivingEntity)entity;
            target.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.WET.get(), 100, this.getWetEffectAmplifier(), false, false, true));
        });
    }

    private void extinguishEntitiesFire() {
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), entity -> entity instanceof LivingEntity).forEach(Entity::m_20095_);
    }

    private void cleanseEntities() {
        LivingEntity owner = (LivingEntity)this.m_19749_();
        if (owner == null) {
            return;
        }
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), entity -> entity instanceof LivingEntity).forEach(entity -> {
            LivingEntity target = (LivingEntity)entity;
            if (target == owner || this.isAlly(owner, target) || this.isTamed(target)) {
                this.cleanseNegativeEffects(target);
            }
        });
    }

    private void cleanseNegativeEffects(LivingEntity entity) {
        List<MobEffect> negativeEffects = entity.m_21220_().stream().map(MobEffectInstance::m_19544_).filter(effect -> effect.m_19483_() == MobEffectCategory.HARMFUL).filter(effect -> !this.isEffectImmune((MobEffect)effect)).toList();
        negativeEffects.forEach(arg_0 -> ((LivingEntity)entity).m_21195_(arg_0));
    }

    private boolean isEffectImmune(MobEffect effect) {
        ResourceLocation effectLocation = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
        List<? extends String> immuneEffects = RainfallAoe.getImmuneEffectsList();
        return effectLocation != null && immuneEffects.contains(effectLocation.toString());
    }

    private boolean isAlly(LivingEntity owner, LivingEntity target) {
        return owner.m_5647_() != null && owner.m_5647_().m_83536_(target.m_5647_());
    }

    private boolean isTamed(LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)target;
            return tamableAnimal.m_21824_();
        }
        return false;
    }

    private void spawnRainParticles() {
        double radius = this.getRadius();
        int particleCount = (int)(6.0f * this.getRadius());
        for (int i = 0; i < particleCount; ++i) {
            double randomX = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 * radius - radius);
            double randomY = this.m_20186_() + 10.0;
            double randomZ = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 * radius - radius);
            double velocityY = -0.5 - this.f_19796_.m_188500_() * 0.5;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.WATER_DROP, randomX, randomY, randomZ, 0.0, velocityY, 0.0);
        }
    }

    private void spawnCloudParticles() {
        double radius = this.getRadius();
        int particleCount = (int)(1.0f * this.getRadius());
        for (int i = 0; i < particleCount; ++i) {
            double randomX = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 * radius - radius);
            double randomY = this.m_20186_() + 12.0;
            double randomZ = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 * radius - radius);
            double velocityY = -0.5 - this.f_19796_.m_188500_() * 0.5;
            this.m_9236_().m_7106_(ParticleHelper.FOG, randomX, randomY, randomZ, 0.0, velocityY, 0.0);
        }
    }

    public void applyEffect(LivingEntity target) {
    }

    public float getParticleCount() {
        return 0.0f;
    }

    protected float particleYOffset() {
        return 0.25f;
    }

    protected float getParticleSpeedModifier() {
        return 1.4f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    public void onAntiMagic(MagicData magicData) {
        this.m_146870_();
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("WetEffectAmplifier", this.wetEffectAmplifier);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("WetEffectAmplifier", 3)) {
            this.wetEffectAmplifier = compound.m_128451_("WetEffectAmplifier");
        }
    }
}

