/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.mobs.nightwarden_boss;

import com.gametechbc.traveloptics.api.entity.TravelopticsBossInfo;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightwardenBoss
extends AbstractSpellCastingMob
implements Enemy {
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(NightwardenBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final TravelopticsBossInfo bossEvent = new TravelopticsBossInfo(this.m_5446_(), BossEvent.BossBarColor.PURPLE, false, 0);
    private int transitionTime = 120;
    private final RawAnimation phase_transition_1_animation = RawAnimation.begin().thenPlay("dead_king_die");
    private final RawAnimation phase_transition_2_animation = RawAnimation.begin().thenPlay("dead_king_die");

    public NightwardenBoss(Level pLevel) {
        this((EntityType<? extends AbstractSpellCastingMob>)((EntityType)TravelopticsEntities.NIGHTWARDEN_BOSS.get()), pLevel);
        this.m_21530_();
    }

    public NightwardenBoss(EntityType<? extends AbstractSpellCastingMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21530_();
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 450.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.setPhaseOneGoals();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, true));
    }

    private void setPhaseOneGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(goal -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), 3, 5, 80, 160, 3));
        this.f_21345_.m_25352_(3, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 40, 65).setSpells(List.of((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.COUNTERSPELL_SPELL.get(), (AbstractSpell)SpellRegistry.HEAL_SPELL.get()), List.of(), List.of()).setSpellQuality(1.0f, 1.2f));
        this.f_21345_.m_25352_(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 32.0f, (double)0.9f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    private void setPhaseTwoGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(goal -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), 5, 5, 60, 120, 5));
        this.f_21345_.m_25352_(3, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.5, 30, 50).setSpells(List.of((AbstractSpell)SpellRegistry.LIGHTNING_LANCE_SPELL.get(), (AbstractSpell)SpellRegistry.LIGHTNING_LANCE_SPELL.get()), List.of((AbstractSpell)SpellRegistry.COUNTERSPELL_SPELL.get(), (AbstractSpell)SpellRegistry.ABYSSAL_SHROUD_SPELL.get()), List.of((AbstractSpell)TravelopticsSpells.SPECTRAL_BLINK_SPELL.get()), List.of()).setSpellQuality(1.3f, 1.5f).setIsFlying());
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    private void setPhaseThreeGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(goal -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get(), 5, 5, 50, 100, 6));
        this.f_21345_.m_25352_(3, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.75, 25, 45).setSpells(List.of((AbstractSpell)SpellRegistry.FLAMING_STRIKE_SPELL.get(), (AbstractSpell)SpellRegistry.FLAMING_STRIKE_SPELL.get()), List.of((AbstractSpell)SpellRegistry.COUNTERSPELL_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get()), List.of(), List.of()).setSpellQuality(1.5f, 1.8f).setIsFlying());
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        float phaseOneThreshold = this.m_21233_() * 0.7f;
        float phaseTwoThreshold = this.m_21233_() * 0.4f;
        if (this.isPhase(Phase.FIRST)) {
            if (this.m_21223_() <= phaseOneThreshold) {
                this.setPhase(Phase.TRANSITION_1);
                this.transitionTime = 120;
                this.m_20331_(true);
                this.triggerAnim("nightwarden_transition", "phase_1_to_2");
            }
        } else if (this.isPhase(Phase.TRANSITION_1)) {
            if (--this.transitionTime <= 0) {
                this.setPhase(Phase.SECOND);
                this.setPhaseTwoGoals();
                this.m_20331_(false);
            }
        } else if (this.isPhase(Phase.SECOND)) {
            if (this.m_21223_() <= phaseTwoThreshold) {
                this.setPhase(Phase.TRANSITION_2);
                this.transitionTime = 120;
                this.m_20331_(true);
                this.triggerAnim("nightwarden_transition", "phase_2_to_3");
            }
        } else if (this.isPhase(Phase.TRANSITION_2)) {
            if (--this.transitionTime <= 0) {
                this.setPhase(Phase.THIRD);
                this.setPhaseThreeGoals();
                this.m_20331_(false);
            }
        } else if (this.isPhase(Phase.THIRD)) {
            // empty if block
        }
    }

    public boolean m_142079_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean isPhaseOneTransitioning() {
        return this.isPhase(Phase.TRANSITION_1);
    }

    public boolean isPhaseTwoTransitioning() {
        return this.isPhase(Phase.TRANSITION_2);
    }

    public boolean isPhaseTransitioning() {
        return this.isPhaseOneTransitioning() || this.isPhaseTwoTransitioning();
    }

    private void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    private void setPhase(Phase phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase.value);
    }

    public boolean isPhase(Phase phase) {
        return (Integer)this.f_19804_.m_135370_(PHASE) == phase.value;
    }

    protected boolean m_6107_() {
        return this.isPhaseTransitioning() || super.m_6107_();
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)Phase.FIRST.value);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("phase", ((Integer)this.f_19804_.m_135370_(PHASE)).intValue());
        pCompound.m_128405_("transitionTime", this.transitionTime);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        int savedPhase = pCompound.m_128451_("phase");
        this.setPhase(Phase.values()[savedPhase]);
        if (this.isPhaseOneTransitioning() || this.isPhaseTwoTransitioning()) {
            this.transitionTime = pCompound.m_128451_("transitionTime");
        }
        if (this.isPhase(Phase.SECOND)) {
            this.setPhaseTwoGoals();
        } else if (this.isPhase(Phase.THIRD)) {
            this.setPhaseThreeGoals();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "nightwarden_transition", 0, state -> PlayState.STOP).triggerableAnim("phase_1_to_2", this.phase_transition_1_animation).triggerableAnim("phase_2_to_3", this.phase_transition_2_animation)});
        super.registerControllers(controllerRegistrar);
    }

    public boolean shouldAlwaysAnimateHead() {
        return !this.isPhaseTransitioning();
    }

    public boolean isAnimating() {
        return this.isPhaseTransitioning() || super.isAnimating();
    }

    public boolean shouldAlwaysAnimateLegs() {
        return !this.isPhaseTransitioning();
    }

    public static enum Phase {
        FIRST(0),
        TRANSITION_1(1),
        SECOND(2),
        TRANSITION_2(3),
        THIRD(4);

        final int value;

        private Phase(int value) {
            this.value = value;
        }
    }
}

