/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.util.TravelopticsTags;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class SpectralBlinkEffect
extends MobEffect {
    public SpectralBlinkEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity != null) {
            Level world = entity.m_9236_();
            MobEffectInstance effectInstance = entity.m_21124_((MobEffect)this);
            if (effectInstance != null) {
                int duration = effectInstance.m_19557_();
                int level = amplifier + 1;
                double range = 1.0 + (double)level;
                if (duration == 60) {
                    world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (duration > 60) {
                    entity.m_21195_((MobEffect)this);
                    entity.m_7292_(new MobEffectInstance((MobEffect)this, 60, amplifier, false, true));
                }
                for (Entity nearbyEntity : world.m_45933_((Entity)entity, entity.m_20191_().m_82400_(range))) {
                    if (!(nearbyEntity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)nearbyEntity;
                    if (nearbyEntity == entity) continue;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10, 0, false, false));
                }
                if (duration == 1) {
                    this.handleBlinkLogic(entity, amplifier, range, world);
                }
            }
        }
    }

    private void handleBlinkLogic(LivingEntity entity, int amplifier, double range, Level world) {
        boolean hasSpectralShift = CuriosApi.getCuriosHelper().findEquippedCurio((Item)TravelopticsItems.AMULET_OF_SPECTRAL_SHIFT.get(), entity).isPresent();
        if (entity.m_6047_() && hasSpectralShift) {
            this.teleportEntityToPlayer(entity, range, world);
        } else {
            this.teleportPlayerToEntity(entity, range, world);
        }
    }

    private void teleportEntityToPlayer(LivingEntity entity, double range, Level world) {
        AABB boundingBox;
        Vec3 viewVec;
        Vec3 endVec;
        Vec3 startVec = entity.m_20299_(1.0f);
        EntityHitResult entityHitResult = this.getForgivingEntityHitResult(world, entity, startVec, endVec = startVec.m_82549_((viewVec = entity.m_20154_()).m_82490_(range)), boundingBox = entity.m_20191_().m_82369_(viewVec.m_82490_(range)).m_82400_(1.0));
        if (entityHitResult != null && entityHitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity hitEntity = entityHitResult.m_82443_();
            if (hitEntity.m_6095_().m_204039_(TravelopticsTags.SPECTRAL_SHIFT_BLACKLIST)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237113_((String)(hitEntity.m_7755_().getString() + " cannot be teleported!")), true);
                }
                return;
            }
            Vec3 targetPos = entity.m_20182_();
            hitEntity.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_SUCCESS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237113_((String)("Teleported " + hitEntity.m_7755_().getString() + " to you!")), true);
            }
        } else {
            this.playFailedBlinkPostEffects(world, (Entity)entity);
        }
    }

    private void teleportPlayerToEntity(LivingEntity entity, double range, Level world) {
        AABB boundingBox;
        Vec3 viewVec;
        Vec3 endVec;
        Vec3 startVec = entity.m_20299_(1.0f);
        EntityHitResult entityHitResult = this.getForgivingEntityHitResult(world, entity, startVec, endVec = startVec.m_82549_((viewVec = entity.m_20154_()).m_82490_(range)), boundingBox = entity.m_20191_().m_82369_(viewVec.m_82490_(range)).m_82400_(1.0));
        if (entityHitResult != null && entityHitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity hitEntity = entityHitResult.m_82443_();
            if (hitEntity.m_6095_().m_204039_(TravelopticsTags.SPECTRAL_BLINK_BLACKLIST)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237113_((String)(hitEntity.m_7755_().getString() + " cannot be teleported to!")), true);
                }
                return;
            }
            Vec3 targetPos = hitEntity.m_20182_();
            entity.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_SUCCESS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"effect.traveloptics.spectral_blink.success", (Object[])new Object[]{hitEntity.m_7755_()}), true);
            }
        } else {
            this.playFailedBlinkPostEffects(world, (Entity)entity);
        }
    }

    private void playFailedBlinkPostEffects(Level world, Entity entity) {
        world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_FAILED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"effect.traveloptics.spectral_blink.missed").m_130940_(ChatFormatting.RED), true);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private EntityHitResult getForgivingEntityHitResult(Level world, LivingEntity entity, Vec3 startVec, Vec3 endVec, AABB boundingBox) {
        EntityHitResult entityHitResult = null;
        double closestDistance = Double.MAX_VALUE;
        double forgivenessRadius = 0.5;
        for (Entity targetEntity : world.m_6249_((Entity)entity, boundingBox, e -> !e.m_5833_() && e.m_6087_())) {
            double distance;
            AABB entityBoundingBox = targetEntity.m_20191_().m_82400_((double)targetEntity.m_6143_() + forgivenessRadius);
            if (!entityBoundingBox.m_82371_(startVec, endVec).isPresent() || !((distance = startVec.m_82554_(targetEntity.m_20191_().m_82399_())) < closestDistance)) continue;
            closestDistance = distance;
            entityHitResult = new EntityHitResult(targetEntity);
        }
        return entityHitResult;
    }
}

