/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.compat.effects;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SunstrikeEffect
extends MagicMobEffect {
    private static final int MIN_TARGETS = 7;
    private static final int MAX_TARGETS = 10;

    public SunstrikeEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        int tickRate = 60 - (pAmplifier - 1) * 2;
        return pDuration % tickRate == 0;
    }

    public void m_6742_(LivingEntity entity, int pAmplifier) {
        double radius = this.getBaseRadius(pAmplifier);
        double height = 12.0;
        Level world = entity.m_9236_();
        AABB box = entity.m_20191_().m_82377_(radius, height, radius);
        int targetsSpawned = 0;
        int maxTargets = Math.min(10, 7 + world.f_46441_.m_188503_(4));
        for (LivingEntity targetEntity : world.m_45976_(LivingEntity.class, box)) {
            if (!this.isValidTarget(targetEntity, entity, radius)) continue;
            this.spawnSunstrike(targetEntity, world, entity);
            if (++targetsSpawned < maxTargets) continue;
            break;
        }
    }

    private boolean isValidTarget(LivingEntity target, LivingEntity caster, double radius) {
        return target != caster && target.m_6087_() && !target.m_20031_(target.m_5647_()) && !target.m_5833_() && (double)this.horizontalDistanceSqr(target, caster) < radius * radius && !Utils.shouldHealEntity((LivingEntity)caster, (LivingEntity)target) && Utils.hasLineOfSight((Level)caster.m_9236_(), (Entity)caster, (Entity)target, (boolean)false);
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, LivingEntity entity2) {
        double dx = livingEntity.m_20185_() - entity2.m_20185_();
        double dz = livingEntity.m_20189_() - entity2.m_20189_();
        return (float)(dx * dx + dz * dz);
    }

    private void spawnSunstrike(LivingEntity targetEntity, Level world, LivingEntity caster) {
        Entity strike;
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation("mowziesmobs", "sunstrike"));
        if (entityType != null && (strike = entityType.m_20615_(world)) != null) {
            Vec3 targetPos = targetEntity.m_20182_();
            strike.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            world.m_7967_(strike);
        }
    }

    private double getBaseRadius(int pAmplifier) {
        double baseRadius = 14.0;
        double radiusIncreasePerLevel = 2.0;
        return baseRadius + (double)(pAmplifier - 1) * radiusIncreasePerLevel;
    }
}

