/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GeneralUtils {
    private static final Random RANDOM = new Random();

    public static LivingEntity findNearestTarget(Level level, LivingEntity caster, double range, boolean ignoreAllies, boolean ignoreTamed, boolean randomSelection) {
        AABB boundingBox = new AABB(caster.m_20185_() - range, caster.m_20186_() - range, caster.m_20189_() - range, caster.m_20185_() + range, caster.m_20186_() + range, caster.m_20189_() + range);
        List possibleTargets = level.m_6443_(LivingEntity.class, boundingBox, entity -> {
            TamableAnimal tamable;
            if (entity == caster) {
                return false;
            }
            if (ignoreAllies && caster.m_7307_((Entity)entity)) {
                return false;
            }
            return !ignoreTamed || !(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).m_21824_() || tamable.m_269323_() != caster;
        });
        if (possibleTargets.isEmpty()) {
            return null;
        }
        return randomSelection ? (LivingEntity)possibleTargets.get(RANDOM.nextInt(possibleTargets.size())) : (LivingEntity)possibleTargets.stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)caster).m_20280_(arg_0))).orElse(null);
    }

    public static void applyFlightBoost(Player player, double boostScale, double targetSpeed, boolean normalizeSpeed, boolean hurtMarked) {
        Vec3 motion = player.m_20184_();
        Vec3 boost = player.m_20154_().m_82490_(boostScale);
        Vec3 newMotion = motion.m_82549_(boost);
        if (normalizeSpeed && newMotion.m_82553_() > targetSpeed) {
            newMotion = newMotion.m_82541_().m_82490_(targetSpeed);
        }
        player.m_20256_(newMotion);
        player.f_19864_ = hurtMarked;
    }

    public static void applyFlightSpeedLimit(Player player, double targetSpeed, boolean normalizeSpeed, boolean hurtMarked) {
        Vec3 motion = player.m_20184_();
        if (normalizeSpeed && motion.m_82553_() > targetSpeed) {
            motion = motion.m_82541_().m_82490_(targetSpeed);
        }
        player.m_20256_(motion);
        player.f_19864_ = hurtMarked;
    }
}

