/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen;

import java.util.function.Function;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.DatagenSystem;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.RegistryProvider;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.mod.ModX;

public abstract class DatagenContext {
    private final DatagenStage stage;
    private final DatagenSystem system;
    private final PackTarget target;

    protected DatagenContext(DatagenStage stage, DatagenSystem system, PackTarget target) {
        this.stage = stage;
        this.system = system;
        this.target = target;
    }

    public DatagenStage stage() {
        return this.stage;
    }

    public ModX mod() {
        return this.system.mod();
    }

    public DatagenSystem system() {
        return this.system;
    }

    public ExistingFileHelper fileHelper() {
        return this.system.fileHelper();
    }

    public PackTarget target() {
        if (this.stage != DatagenStage.DATAGEN) {
            throw new UnsupportedOperationException("Can't access the pack target in " + this.stage + " stage");
        }
        return this.target;
    }

    public PackOutput output() {
        return this.target().packOutput();
    }

    public RegistrySet registries() {
        return this.target.registries();
    }

    public abstract <T extends RegistryProvider> T findRegistryProvider(Class<T> var1);

    public abstract <T extends DataProvider> T findDataProvider(Class<T> var1);

    public abstract void addAdditionalProvider(Function<DatagenContext, DataProvider> var1);
}

