/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientStack(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public static final IngredientStack EMPTY = new IngredientStack(Ingredient.f_43901_, 0);

    public IngredientStack(Ingredient ingredient, int count) {
        if (count <= 0 || ingredient.m_43947_()) {
            this.ingredient = Ingredient.f_43901_;
            this.count = 0;
        } else {
            this.ingredient = ingredient;
            this.count = count;
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        return stack.m_41613_() >= this.count && this.ingredient.test(stack);
    }

    public boolean isEmpty() {
        return this.count == 0 || this.ingredient.m_43947_();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("Ingredient", this.ingredient.m_43942_());
        json.addProperty("Count", (Number)this.count);
        return json;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.count);
        this.ingredient.m_43923_(buffer);
    }

    public static IngredientStack fromJson(JsonObject json) {
        Ingredient ingredient = json.has("Ingredient") ? Ingredient.m_43917_((JsonElement)json.get("Ingredient")) : Ingredient.f_43901_;
        int count = json.has("Count") && json.get("Count").isJsonPrimitive() ? json.get("Count").getAsInt() : 1;
        return new IngredientStack(ingredient, count);
    }

    public static IngredientStack fromNetwork(FriendlyByteBuf buffer) {
        int count = buffer.m_130242_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new IngredientStack(ingredient, count);
    }
}

